/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkTypeAspectual;
import edu.mit.semantics.core.rep.timelink.LinkTypeSubordinate;
import edu.mit.semantics.core.rep.timelink.LinkTypeTemporal;
import edu.mit.semantics.core.rep.timelink.TimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeTimeLinkFeatureActionGroup
extends ActionGroup {
    private IMenuManager typeMenu;
    private IMenuManager aspectualMenu;
    private IMenuManager subordinateMenu;
    private IMenuManager temporalMenu;

    public ChangeTimeLinkFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        this.createActions(editor, provider);
    }

    public IRep getRep() {
        return TimeLinkRep.getInstance();
    }

    protected void createActions(IStoryEditor editor, ISelectionProvider provider) {
        this.typeMenu = new MenuManager("&Link Type");
        this.typeMenu.setRemoveAllWhenShown(true);
        this.typeMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)ChangeTimeLinkFeatureActionGroup.this.temporalMenu);
                manager.add((IContributionItem)ChangeTimeLinkFeatureActionGroup.this.subordinateMenu);
                manager.add((IContributionItem)ChangeTimeLinkFeatureActionGroup.this.aspectualMenu);
            }
        });
        this.temporalMenu = new MenuManager("&Temporal");
        this.temporalMenu.setRemoveAllWhenShown(true);
        this.temporalMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkTypeTemporal[] linkTypeTemporalArray = LinkTypeTemporal.values();
                int n = linkTypeTemporalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LinkTypeTemporal t = linkTypeTemporalArray[n2];
                    manager.add((IAction)new ChangeTypeAction((IRelType)t, editor, provider));
                    ++n2;
                }
            }
        });
        this.subordinateMenu = new MenuManager("&Subordinate");
        this.subordinateMenu.setRemoveAllWhenShown(true);
        this.subordinateMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkTypeSubordinate[] linkTypeSubordinateArray = LinkTypeSubordinate.values();
                int n = linkTypeSubordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LinkTypeSubordinate t = linkTypeSubordinateArray[n2];
                    manager.add((IAction)new ChangeTypeAction((IRelType)t, editor, provider));
                    ++n2;
                }
            }
        });
        this.aspectualMenu = new MenuManager("&Aspectual");
        this.aspectualMenu.setRemoveAllWhenShown(true);
        this.aspectualMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkTypeAspectual[] linkTypeAspectualArray = LinkTypeAspectual.values();
                int n = linkTypeAspectualArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LinkTypeAspectual t = linkTypeAspectualArray[n2];
                    manager.add((IAction)new ChangeTypeAction((IRelType)t, editor, provider));
                    ++n2;
                }
            }
        });
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        boolean all = obj instanceof ITimeLink;
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (all || obj instanceof IRelType) {
            menu.appendToGroup("additions", (IContributionItem)this.typeMenu);
        }
    }

    public class ChangeTypeAction
    extends Action {
        private IRelType linkType;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeTypeAction(IRelType linkType, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeTimeLinkFeatureActionGroup.extractName(linkType), 2);
            if (linkType == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.linkType = linkType;
            this.editor = editor;
            this.provider = provider;
        }

        public IRelType getLinkType() {
            return this.linkType;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeTimeLinkFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof ITimeLink) {
                ITimeLink link = (ITimeLink)element;
                return link.getRelationType() == this.linkType;
            }
            return false;
        }

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            ITimeLink oldLink = (ITimeLink)oldDesc.getData();
            TimeLink newLink = new TimeLink(this.linkType, oldLink.getSource(), oldLink.getRelated(), oldLink.getSignal());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newLink.calculatePosition(), (IData)newLink, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }
    }
}

