/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.semantics.core.rep.function.IFunctionTag;
import edu.mit.semantics.core.rep.function.model.IFunctionInstanceModel;
import edu.mit.semantics.core.rep.function.model.IFunctionModel;
import edu.mit.semantics.ui.content.FunctionContentProvider;
import edu.mit.semantics.ui.controllers.FunctionController;
import edu.mit.semantics.ui.controllers.IFunctionController;
import edu.mit.semantics.ui.controllers.IFunctionInstanceController;
import edu.mit.semantics.ui.label.FunctionLabelProvider;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.EditAction;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;

public class FunctionCreatorPage
extends HelperPage
implements ICreatorPage {
    public static final String ID = FunctionCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Function";
    public static String actionLabelSave = "Save Function";
    public static String actionLabelClear = "Clear Function";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new function", 1);
    public static IMessageProvider commitMessage = new Message("Press the 'commit' button to add this function to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this function in the story model", 1);
    public static IMessageProvider createMessage = new Message("Press the 'create' button to add this instance to the function", 3);
    protected IFunctionController controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected Text symbolText;
    protected Text subtypeText;
    protected Button invertedButton;
    protected ComboViewer typeCombo;
    protected SegmentSetCaptureWidget<IFunctionInstanceController> instanceWidget;
    protected Button createInstanceButton;
    protected ButtonAction createInstanceAction;
    protected TreeViewer functionViewer;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;
    protected IAction editAction;
    protected IAction deleteAction;

    public IFunctionController getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new FunctionController("edu.mit.story.ui.annotation.target0", this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        SashForm sash = new SashForm(control, 256);
        ColorManager.inheritColors((Control)sash);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite widgets = new Composite((Composite)sash, 0);
        widgets.setBackground(sash.getBackground());
        widgets.setForeground(sash.getForeground());
        widgets.setLayoutData((Object)new GridData(4, 0, true, false));
        widgets.setLayout((Layout)new GridLayout(2, false));
        this.createControlSymbols(widgets);
        this.createControlInstance(widgets);
        this.createControlButtons(widgets);
        this.functionViewer = new TreeViewer((Composite)sash, 2820);
        this.functionViewer.setContentProvider((IContentProvider)new FunctionContentProvider(this.getStoryEditor()));
        this.functionViewer.setLabelProvider((IBaseLabelProvider)new FunctionLabelProvider(this.getStoryEditor()));
        this.functionViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.getController().getModel()}));
        this.functionViewer.setAutoExpandLevel(-1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.functionViewer);
        ColorManager.inheritColors((Control)this.functionViewer.getTree());
        this.editAction = new EditInstanceAction();
        this.deleteAction = new DeleteInstanceAction();
        MenuManager m = new MenuManager();
        m.add((IContributionItem)new Separator("group.edit"));
        m.appendToGroup("group.edit", this.editAction);
        m.appendToGroup("group.edit", this.deleteAction);
        this.functionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)SelectionUtils.extractSingle((ISelection)event.getSelection(), StoryEditorContentProvider.Element.class);
                boolean enable = element != null && element.getElement() instanceof IFunctionInstanceModel;
                FunctionCreatorPage.this.deleteAction.setEnabled(enable);
                FunctionCreatorPage.this.editAction.setEnabled(enable);
            }
        });
        this.functionViewer.getTree().setMenu(m.createContextMenu((Control)this.functionViewer.getTree()));
        sash.setWeights(new int[]{2, 1});
        this.messageManager = new MessageProviderManager();
        this.messageManager.setDefaultMesage(commitMessage);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getInstanceController().getModel(), true);
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FunctionCreatorPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void createControlSymbols(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Symbol");
        Composite remainder = new Composite(parent, 0);
        remainder.setLayoutData((Object)new GridData(4, 4, false, false));
        ColorManager.inheritColors((Control)remainder);
        remainder.setLayout((Layout)FunctionCreatorPage.zeroMargins((GridLayout)new GridLayout(4, true)));
        this.symbolText = new Text(remainder, 2048);
        ColorManager.inheritColors((Control)this.symbolText);
        this.symbolText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.symbolText.setTextLimit(10);
        this.symbolText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionCreatorPage.this.getController().setSymbol(FunctionCreatorPage.this.symbolText.getText());
            }
        });
        label = new Label(remainder, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Subtype");
        this.subtypeText = new Text(remainder, 2048);
        ColorManager.inheritColors((Control)this.subtypeText);
        this.subtypeText.setTextLimit(10);
        this.subtypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionCreatorPage.this.getController().setSubType(FunctionCreatorPage.this.subtypeText.getText());
            }
        });
        this.invertedButton = new Button(remainder, 32);
        this.invertedButton.setText("Inverted?");
        ColorManager.inheritColors((Control)this.invertedButton);
        this.invertedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionCreatorPage.this.getController().getModel().setInverted(FunctionCreatorPage.this.invertedButton.getSelection());
            }
        });
    }

    protected void createControlInstance(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Instance");
        this.instanceWidget = new SegmentSetCaptureWidget<IFunctionInstanceController>(parent, 0, this.controller.getInstanceController()){

            protected void createLeadingControls(Composite parent) {
                parent.setLayout((Layout)FunctionCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                FunctionCreatorPage.this.typeCombo = new ComboViewer(parent, 8);
                FunctionCreatorPage.this.typeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
                FunctionCreatorPage.this.typeCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
                FunctionCreatorPage.this.typeCombo.setInput((Object)IFunctionInstance.InstanceType.values());
                FunctionCreatorPage.this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IFunctionInstance.InstanceType selType = (IFunctionInstance.InstanceType)SelectionUtils.extractSingle((ISelection)(this).FunctionCreatorPage.this.typeCombo.getSelection(), IFunctionInstance.InstanceType.class);
                        ((IFunctionInstanceController)this.getController()).setInstanceType(selType);
                    }
                });
            }

            protected void createTrailingControls(Composite parent) {
                parent.setLayout((Layout)FunctionCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                FunctionCreatorPage.this.createInstanceButton = new Button(parent, 0);
                ColorManager.inheritColors((Control)FunctionCreatorPage.this.createInstanceButton);
                FunctionCreatorPage.this.createInstanceButton.setText("Create");
                FunctionCreatorPage.this.createInstanceAction = new ButtonAction(FunctionCreatorPage.this.createInstanceButton){

                    public void run() {
                        FunctionCreatorPage.this.getController().createInstance();
                    }
                };
            }
        };
        ColorManager.inheritColors(this.instanceWidget);
        this.instanceWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createControlButtons(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite buttonParent = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttonParent);
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        label = new Label(buttonParent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                FunctionCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                FunctionCreatorPage.this.controller.clear();
            }
        };
    }

    protected void updateFromModel() {
        StructuredSelection expectedType;
        IFunctionModel funcModel = this.controller.getModel();
        IFunctionInstanceModel instModel = this.controller.getInstanceController().getModel();
        boolean enableCommit = !funcModel.isCleared() && funcModel.getMessageType() != 3 && instModel.isCleared();
        boolean enableCreate = !instModel.isCleared() && instModel.getMessageType() != 3;
        boolean enableClear = !funcModel.isCleared() || !instModel.isCleared();
        boolean isLoaded = funcModel.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        IMessageProvider defaultMsg = isLoaded ? saveMessage : commitMessage;
        defaultMsg = enableCreate ? createMessage : defaultMsg;
        IFunctionTag tag = funcModel.getFunctionTag();
        String symbol = tag.getSymbol();
        String subtype = tag.getSubtype();
        boolean isInverted = tag.isInverted();
        if (!this.symbolText.getText().equals(symbol)) {
            this.symbolText.setText(symbol);
        }
        if (!this.subtypeText.getText().equals(subtype)) {
            this.subtypeText.setText(subtype);
        }
        if (this.invertedButton.getSelection() != isInverted) {
            this.invertedButton.setSelection(isInverted);
        }
        if (!(expectedType = new StructuredSelection((Object)instModel.getInstanceType())).equals(this.typeCombo.getSelection())) {
            this.typeCombo.setSelection((ISelection)expectedType);
        }
        if (enableCreate != this.createInstanceButton.isEnabled()) {
            this.createInstanceButton.setEnabled(enableCreate);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        this.functionViewer.refresh();
        this.functionViewer.expandAll();
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        this.instanceWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.instanceWidget.getAddAction().getActionDefinitionId(), this.instanceWidget.getAddAction());
        this.instanceWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        actionBars.setGlobalActionHandler(this.instanceWidget.getSubtractAction().getActionDefinitionId(), this.instanceWidget.getSubtractAction());
        this.instanceWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.instanceWidget.getClearAction().getActionDefinitionId(), this.instanceWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.delete", this.deleteAction);
        actionBars.setGlobalActionHandler("edu.mit.story.ui.command.edit", this.editAction);
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    protected class DeleteInstanceAction
    extends DeleteAction {
        protected DeleteInstanceAction() {
        }

        protected void doDelete() {
            StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)SelectionUtils.extractSingle((ISelection)FunctionCreatorPage.this.functionViewer.getSelection(), StoryEditorContentProvider.Element.class);
            IFunctionInstanceModel model = (IFunctionInstanceModel)element.getElement();
            FunctionCreatorPage.this.controller.getModel().getInstances().remove((Object)model);
            IFunctionInstanceModel instModel = FunctionCreatorPage.this.controller.getInstanceController().getModel();
            if (instModel.getLoaded() == model) {
                instModel.clear();
            }
        }
    }

    protected class EditInstanceAction
    extends EditAction {
        protected void doEdit() {
            StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)SelectionUtils.extractSingle((ISelection)FunctionCreatorPage.this.functionViewer.getSelection(), StoryEditorContentProvider.Element.class);
            IFunctionInstanceModel model = (IFunctionInstanceModel)element.getElement();
            FunctionCreatorPage.this.controller.getInstanceController().edit((IFunctionInstance)model);
        }
    }
}

