/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.parsing.ui.widgets.SegmentCaptureWidget;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.LinkType;
import edu.mit.semantics.core.rep.timelink.model.ITimeLinkModel;
import edu.mit.semantics.ui.controllers.ITimeLinkController;
import edu.mit.semantics.ui.controllers.TimeLinkController;
import edu.mit.semantics.ui.widgets.TimeLinkParticipantCaptureWidget;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class TimeLinkCreatorPage
extends HelperPage
implements ChangeListener,
ICreatorPage {
    public static final String ID = TimeLinkCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Temporal Link";
    public static String actionLabelSave = "Save Temporal Link";
    public static String actionLabelClear = "Clear Temporal Link";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new temporal link", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this link to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this link in the story model", 1);
    protected ITimeLinkController controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected ComboViewer linkTypeCombo;
    protected ComboViewer relTypeCombo;
    protected DescCaptureWidget<IDescController<?>> sourceWidget;
    protected DescCaptureWidget<IDescController<?>> relatedWidget;
    protected SegmentCaptureWidget<ISegmentController> signalWidget;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public ITimeLinkController getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new TimeLinkController(this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputParent = new Composite(control, 0);
        inputParent.setBackground(control.getBackground());
        inputParent.setForeground(control.getForeground());
        inputParent.setLayoutData((Object)new GridData(4, 0, true, false));
        inputParent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Signal");
        this.signalWidget = new SegmentCaptureWidget<ISegmentController>(inputParent, 65536, this.controller.getSignalController()){

            protected void createTrailingControls(Composite parent) {
                parent.setLayout((Layout)new GridLayout(4, false));
                ArrayContentProvider cp = new ArrayContentProvider();
                Label label = new Label(parent, 0);
                label.setBackground(parent.getBackground());
                label.setForeground(parent.getForeground());
                label.setText("Link Type");
                LinkType[] input = LinkType.values();
                TimeLinkCreatorPage.this.linkTypeCombo = new ComboViewer(parent);
                TimeLinkCreatorPage.this.linkTypeCombo.setContentProvider((IContentProvider)cp);
                TimeLinkCreatorPage.this.linkTypeCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
                TimeLinkCreatorPage.this.linkTypeCombo.setInput((Object)input);
                TimeLinkCreatorPage.this.linkTypeCombo.getCombo().setVisibleItemCount(input.length);
                TimeLinkCreatorPage.this.linkTypeCombo.getControl().setBackground(parent.getBackground());
                TimeLinkCreatorPage.this.linkTypeCombo.getControl().setForeground(parent.getForeground());
                TimeLinkCreatorPage.this.linkTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        LinkType sel = (LinkType)SelectionUtils.extractSingle((ISelection)event.getSelection(), LinkType.class);
                        TimeLinkCreatorPage.this.getController().setRelatedType((IRelType)sel.getUnspecifiedRelation());
                    }
                });
                label = new Label(parent, 0);
                label.setBackground(parent.getBackground());
                label.setForeground(parent.getForeground());
                label.setText("Relation Type");
                TimeLinkCreatorPage.this.relTypeCombo = new ComboViewer(parent);
                TimeLinkCreatorPage.this.relTypeCombo.setContentProvider((IContentProvider)cp);
                TimeLinkCreatorPage.this.relTypeCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
                TimeLinkCreatorPage.this.relTypeCombo.getControl().setBackground(parent.getBackground());
                TimeLinkCreatorPage.this.relTypeCombo.getControl().setForeground(parent.getForeground());
                TimeLinkCreatorPage.this.relTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IRelType sel = (IRelType)SelectionUtils.extractSingle((ISelection)event.getSelection(), IRelType.class);
                        TimeLinkCreatorPage.this.getController().setRelatedType(sel);
                    }
                });
            }
        };
        this.signalWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.signalWidget.getCaptureAction().setText("Capture Signal");
        this.signalWidget.getCaptureAction().setToolTipText("Capture Signal");
        this.signalWidget.getClearAction().setText("Clear Signal");
        this.signalWidget.getClearAction().setToolTipText("Clear Signal");
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Source");
        this.sourceWidget = new TimeLinkParticipantCaptureWidget(inputParent, this.controller.getSourceController());
        this.sourceWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.sourceWidget.getCaptureAction().setText("Capture Source");
        this.sourceWidget.getCaptureAction().setToolTipText("Capture Source");
        this.sourceWidget.getClearAction().setText("Clear Source");
        this.sourceWidget.getClearAction().setToolTipText("Clear Source");
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Related");
        this.relatedWidget = new TimeLinkParticipantCaptureWidget(inputParent, this.controller.getRelatedController());
        this.relatedWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.relatedWidget.getCaptureAction().setText("Capture Related");
        this.relatedWidget.getCaptureAction().setToolTipText("Capture Related");
        this.relatedWidget.getClearAction().setText("Clear Related");
        this.relatedWidget.getClearAction().setToolTipText("Clear Related");
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite buttonParent = new Composite(inputParent, 0);
        buttonParent.setBackground(inputParent.getBackground());
        buttonParent.setForeground(inputParent.getForeground());
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        label = new Label(buttonParent, 0);
        label.setBackground(buttonParent.getBackground());
        label.setForeground(buttonParent.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                TimeLinkCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                TimeLinkCreatorPage.this.controller.clear();
            }
        };
        this.messageManager = new MessageProviderManager(createMessage, (ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getLinkModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.updateFromModel();
    }

    protected void updateFromModel() {
        Object[] input;
        ITimeLinkModel linkModel = this.controller.getLinkModel();
        boolean enableCommit = !linkModel.isCleared() && linkModel.getMessageType() != 3;
        boolean enableClear = !linkModel.isCleared();
        Object[] relInput = linkModel.getRelationType().getType().getUnspecifiedRelation().getClass().getEnumConstants();
        StructuredSelection linkTypeSel = new StructuredSelection((Object)linkModel.getLinkType());
        StructuredSelection relTypeSel = new StructuredSelection((Object)linkModel.getRelationType());
        boolean isLoaded = linkModel.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        IMessageProvider defaultMsg = isLoaded ? saveMessage : createMessage;
        Object[] objectArray = input = this.relTypeCombo.getInput() instanceof Object[] ? (Object[])this.relTypeCombo.getInput() : null;
        if (!Arrays.equals(relInput, input)) {
            this.relTypeCombo.setInput((Object)relInput);
            this.relTypeCombo.getCombo().setVisibleItemCount(relInput.length);
        }
        if (!this.linkTypeCombo.getSelection().equals(linkTypeSel)) {
            this.linkTypeCombo.setSelection((ISelection)linkTypeSel);
        }
        if (!this.relTypeCombo.getSelection().equals(relTypeSel)) {
            this.relTypeCombo.setSelection((ISelection)relTypeSel);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        this.signalWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.sourceWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        this.relatedWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.3");
        actionBars.setGlobalActionHandler(this.signalWidget.getCaptureAction().getActionDefinitionId(), this.signalWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.sourceWidget.getCaptureAction().getActionDefinitionId(), this.sourceWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.relatedWidget.getCaptureAction().getActionDefinitionId(), this.relatedWidget.getCaptureAction());
        this.signalWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.sourceWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.2");
        this.relatedWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.3");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.signalWidget.getClearAction().getActionDefinitionId(), this.signalWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.sourceWidget.getClearAction().getActionDefinitionId(), this.sourceWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.relatedWidget.getClearAction().getActionDefinitionId(), this.relatedWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
    }

    public void stateChanged(ChangeEvent event) {
        this.updateFromModel();
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }
}

