/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.widgets;

import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WordInfoWidget
extends Composite {
    IBaseWordInfo wordInfo = null;
    IHasPosition wordPos = null;
    Text wordText;
    Text posText;
    Text stemText;
    Text tagText;

    public WordInfoWidget(Composite parent, int style) {
        this(parent, style, true);
    }

    public WordInfoWidget(Composite parent, int style, boolean showPos) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createControl(this, showPos);
    }

    protected void createControl(Composite parent, boolean showPos) {
        Label label = new Label(parent, 0);
        label.setText("Word:");
        this.wordText = new Text(parent, 0);
        this.wordText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.wordText.setEditable(false);
        if (showPos) {
            label = new Label(parent, 0);
            label.setText("Position:");
            this.posText = new Text(parent, 0);
            this.posText.setLayoutData((Object)new GridData(4, 0, true, false));
            this.posText.setEditable(false);
        }
        label = new Label(parent, 0);
        label.setText("Stem:");
        this.stemText = new Text(parent, 0);
        this.stemText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.stemText.setEditable(false);
        label = new Label(parent, 0);
        label.setText("Tag:");
        this.tagText = new Text(parent, 0);
        this.tagText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.tagText.setEditable(false);
    }

    public IBaseWordInfo getWordInfo() {
        return this.wordInfo;
    }

    public IHasPosition getWordPosition() {
        return this.wordPos;
    }

    public boolean setInput(IBaseWordInfo wordInfo, IHasPosition wordPos) {
        boolean enable;
        this.wordInfo = wordInfo;
        this.wordPos = wordPos;
        boolean bl = enable = wordInfo != null;
        if (enable) {
            this.wordText.setText(wordInfo.getBaseToken().getSurface());
            IStemData stem = wordInfo.getStem();
            String stemStr = stem == null ? "n/a" : stem.getStem();
            this.stemText.setText(stemStr);
            if (this.posText != null) {
                String posStr = wordPos == null ? "" : PositionUtils.toUserFriendlyString((IHasPosition)wordPos);
                this.posText.setText(posStr);
            }
            IPosData tag = wordInfo.getPosTag();
            StringBuilder sb = new StringBuilder();
            sb.append(tag.getTag().getTagString());
            if (tag.isAuxiliary()) {
                sb.append("-aux");
            }
            sb.append(" (");
            sb.append(tag.getTag().getName());
            sb.append(")");
            this.tagText.setText(sb.toString());
        } else {
            this.wordText.setText("(none)");
            if (this.posText != null) {
                this.posText.setText("");
            }
            this.stemText.setText("");
            this.tagText.setText("");
        }
        this.wordText.setEnabled(enable);
        if (this.posText != null) {
            this.posText.setEnabled(enable);
        }
        this.stemText.setEnabled(enable);
        this.tagText.setEnabled(enable);
        return true;
    }
}

