/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.mentalstate;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalState;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Version;

public class MentalStateRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.mentalstate";
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public MentalStateRep() {
        super(IMentalState.class, v01);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)CorefRep.getInstance());
        container.add((Object)EventRep.getInstance());
    }

    public String serialize(IData data) {
        IMentalState state = (IMentalState)data;
        return this.serializeV01(state);
    }

    public IMentalState reconstitute(IHasPosition p, String description, IStoryModel model) {
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public IMentalState reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        if (v01.equals((Object)version)) {
            return this.reconstituteV01(p, description, model);
        }
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public String serializeV01(IMentalState state) {
        LinkedList<String> fields = new LinkedList<String>();
        fields.add(state.getValence().name());
        fields.add(Long.toString(state.getCharacter().getID()));
        fields.add(Long.toString(state.getEvent().getID()));
        return BlockMapper.PIPE.serialize(fields);
    }

    public IMentalState reconstituteV01(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(data);
        Valence value = Valence.valueOf((String)fields.get(0));
        long charID = Long.parseLong((String)fields.get(1));
        IDesc charDesc = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(charID);
        long eventID = Long.parseLong((String)fields.get(2));
        IDesc eventDesc = model.getData().getDescriptions(EventRep.getInstance()).getDescription(eventID);
        return new MentalState(value, charDesc, eventDesc);
    }
}

