/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class NoSubordinatingLinkProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.timelink.problem.noSubordinatingLink";

    public NoSubordinatingLinkProblem(IDesc desc, String buildRuleID) {
        super(TimeLinkRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("no appropriate subordinating link");
        this.setSeverity(1);
        this.setDescs(Collections.singleton(desc));
        this.setCheck(ID);
        IDescSet events = this.getDescs().getDescriptions(EventRep.getInstance());
        if (events.size() != 1) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)events.first());
        StringBuilder sb = new StringBuilder();
        IEvent event = (IEvent)((IDesc)events.first()).getData();
        sb.append("The ");
        sb.append(event.getEventClass().getName().toLowerCase());
        sb.append(" event '");
        sb.append(event.getEventTokens().getDisplayText());
        sb.append("' does not originate a subordinating time link");
        switch (event.getEventClass()) {
            case PERCEPTION: {
                sb.append(" of type evidential or negative evidential");
                break;
            }
            case I_ACTION: 
            case I_STATE: {
                sb.append(" of type modal, factive, or counter-factive");
            }
        }
        this.setDescription(sb.toString());
    }
}

