/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.change.CalculateDescsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RecalculateChange;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RecalculateDescHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDescSet ds;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection structured = SelectionUtils.castAsStructuredSelection(selection);
        if (structured == null) {
            throw new IllegalArgumentException();
        }
        TreeSet<IDesc> descs = new TreeSet<IDesc>();
        for (Object element : structured) {
            if (element instanceof IDesc) {
                descs.add((IDesc)element);
                continue;
            }
            if (!(element instanceof Iterable)) continue;
            Iterable itr = (Iterable)element;
            for (Object o : itr) {
                if (!(o instanceof IDesc)) continue;
                descs.add((IDesc)o);
            }
        }
        if (descs.isEmpty() && (ds = SelectionUtils.extractSingle(selection, IDescSet.class)) != null) {
            CalculateDescsChange change = new CalculateDescsChange(ds.getRep());
            IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
            editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
            return null;
        }
        if (descs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        RecalculateChange change = new RecalculateChange(descs);
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

