/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.property.Configuration;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.ui.validation.IConfigurationWidget;
import edu.mit.story.ui.widgets.IPropertyWidget;
import edu.mit.story.ui.widgets.PropertyWidget;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConfigurationWidget
extends ChangeNotifier
implements IConfigurationWidget {
    IConfiguration config;
    MessageProviderManager manager;
    Group widgetControl;
    List<IPropertyWidget> widgets = new ArrayList<IPropertyWidget>(1);

    public ConfigurationWidget(Composite parent, IConfigDescriptor config) {
        this(parent, config.createDefault());
    }

    public ConfigurationWidget(Composite parent, IConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
        this.manager = new MessageProviderManager((ChangeListener)this);
        this.createControl(parent);
    }

    public void createControl(Composite parent) {
        this.widgetControl = new Group(parent, 0);
        this.widgetControl.setText(this.config.getName());
        this.widgetControl.setLayout((Layout)new GridLayout());
        IConfigDescriptor configDesc = this.config.getConfigurationDescriptor();
        if (configDesc.isEmpty()) {
            Label label = new Label((Composite)this.widgetControl, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label.setText("No Properties");
        } else {
            for (IPropertyDescriptor propDesc : configDesc.values()) {
                PropertyWidget propWidget = new PropertyWidget((Composite)this.widgetControl, (String)this.config.get((Object)propDesc.getID()), propDesc);
                propWidget.getControl().setLayoutData((Object)new GridData(4, 0, true, false));
                this.manager.add((INotifyingMessageProvider)propWidget);
                this.widgets.add(propWidget);
            }
        }
    }

    public Control getControl() {
        return this.widgetControl;
    }

    public IConfiguration getConfiguration() {
        Configuration result = new Configuration(this.config);
        for (IPropertyWidget widget : this.widgets) {
            IConfiguration config;
            IPropertyDescriptor pDesc = widget.getPropertyDescriptor();
            result.put((Object)pDesc.getKey(), (Object)widget.getValue());
            if (!pDesc.isConfigurableProperty() || (config = widget.getConfiguration()) == null) continue;
            result.getConfigurations().put(pDesc.getKey(), config);
        }
        return result;
    }

    public String getMessage() {
        return this.manager.getMessage();
    }

    public int getMessageType() {
        return this.manager.getMessageType();
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners(e.getSource());
    }
}

