/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.dialogs;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.IWordInfo;
import edu.mit.parsing.ui.widgets.WordInfoWidget;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.ui.label.WordLabelProvider;
import edu.mit.wordnet.ui.wizards.pages.DefinitionViewer;
import java.util.Collection;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenseChooserDialog
extends SelectionDialog {
    IWordInfo wordInfo;
    IHasPosition wordPos;
    Collection<? extends IWord> choices;
    IDictionary dict;
    WordInfoWidget infoWidget;
    DefinitionViewer defView;
    TableViewer defList;

    protected SenseChooserDialog(Shell parentShell, IWordInfo wordInfo, IHasPosition wordPos, Collection<? extends IWord> choices, IDictionary dict) {
        super(parentShell);
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
        if (wordInfo == null) {
            throw new NullPointerException();
        }
        if (choices.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.wordInfo = wordInfo;
        this.wordPos = wordPos;
        this.choices = choices;
        this.setShellStyle(1264);
        this.setTitle("Choose a Sense");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.createInfoWidget(dialogArea);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Chosen Definition:");
        this.defView = new DefinitionViewer(parent, 2560, this.dict);
        JFaceColors.setColors((Control)this.defView, (Color)parent.getForeground(), (Color)parent.getDisplay().getSystemColor(25));
        GridData data = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)parent);
        data.heightHint = gc.getFontMetrics().getHeight() * 4;
        gc.dispose();
        this.defView.setLayoutData(data);
        this.createDefinitionTable(dialogArea);
        this.infoWidget.setInput((IBaseWordInfo)this.wordInfo, this.wordPos);
        this.defList.setInput(this.choices);
        return dialogArea;
    }

    protected void createInfoWidget(Composite parent) {
        this.infoWidget = new WordInfoWidget(parent, 0);
        this.infoWidget.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void createDefinitionView(Composite parent) {
    }

    protected void createDefinitionTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Potential Definitions:");
        this.defList = new TableViewer(parent, 67588);
        Table table = this.defList.getTable();
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(Math.min(this.choices.size() + 3, 20));
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Synonyms");
        column = new TableColumn(table, 16384);
        column.setText("Gloss");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        table.setLayout((Layout)tableLayout);
        this.defList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.defList.setLabelProvider((IBaseLabelProvider)new WordLabelProvider());
        this.defList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = SelectionUtils.castAsStructuredSelection((ISelection)SenseChooserDialog.this.defList.getSelection());
                SenseChooserDialog.this.setResult(sel.toList());
                IWord word = SenseChooserDialog.this.getChosenSense();
                SenseChooserDialog.this.defView.setInput((ISenseAssignment)new SenseAssignment(word, null));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                SenseChooserDialog.this.okPressed();
            }
        });
    }

    protected String createDetailText(IWord word) {
        if (word == null) {
            return "";
        }
        return word.getSynset().getGloss();
    }

    public IWord getChosenSense() {
        return (IWord)SelectionUtils.extractSingle((Object[])this.getResult(), IWord.class);
    }

    public static IWord open(Shell shell, IWordInfo info, IHasPosition p, Collection<? extends IWord> choices, IDictionary dict) {
        SenseChooserDialog dialog = new SenseChooserDialog(shell, info, p, choices, dict);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getReturnCode() == 1 ? null : (IWord)SelectionUtils.extractSingle((Object[])dialog.getResult(), IWord.class);
    }
}

