/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.AdjMarker;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVerbFrame;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.SenseKey;
import edu.mit.jwi.item.WordID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Word
implements IWord {
    private final IWordID fWordID;
    private final ISynset fSynset;
    private final String fLemma;
    private final ISenseKey fSenseKey;
    private final AdjMarker fAdjMarker;
    private final int fLexID;
    private final List<IVerbFrame> fFrames;
    private final List<IWordID> allWords;
    private final Map<IPointer, List<IWordID>> wordMap;
    private static final String[] lexIDNumStrs = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
    private static final char zero = '0';

    public Word(ISynset synset, int number, String lemma, int lexID, Map<IPointer, ? extends List<IWordID>> pointers) {
        this(synset, number, lemma, lexID, null, null, pointers);
    }

    public Word(ISynset synset, int number, String lemma, int lexID, List<IVerbFrame> frames, Map<IPointer, ? extends List<IWordID>> pointers) {
        this(synset, number, lemma, lexID, null, frames, pointers);
    }

    public Word(ISynset synset, int number, String lemma, int lexID, AdjMarker adjMarker, Map<IPointer, ? extends List<IWordID>> pointers) {
        this(synset, number, lemma, lexID, adjMarker, null, pointers);
    }

    public Word(ISynset synset, int number, String lemma, int lexID, AdjMarker adjMarker, List<IVerbFrame> frames, Map<IPointer, ? extends List<IWordID>> pointers) {
        if (synset == null) {
            throw new NullPointerException();
        }
        Word.checkLexicalID(lexID);
        Word.checkWordNumber(number);
        if (synset.getPOS() != POS.ADJECTIVE && adjMarker != null) {
            throw new IllegalArgumentException();
        }
        this.fSynset = synset;
        this.fWordID = new WordID((ISynsetID)synset.getID(), number, lemma);
        this.fLemma = lemma;
        this.fLexID = lexID;
        this.fAdjMarker = adjMarker;
        this.fSenseKey = new SenseKey(this.fLemma, lexID, synset);
        LinkedHashSet hiddenSet = null;
        HashMap hiddenMap = null;
        if (pointers != null) {
            hiddenSet = new LinkedHashSet();
            hiddenMap = new HashMap(pointers.size());
            for (Map.Entry<IPointer, ? extends List<IWordID>> entry : pointers.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                hiddenMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
                hiddenSet.addAll(entry.getValue());
            }
        }
        this.allWords = hiddenSet != null && !hiddenSet.isEmpty() ? Collections.unmodifiableList(new ArrayList(hiddenSet)) : Collections.emptyList();
        this.wordMap = hiddenMap != null && !hiddenMap.isEmpty() ? Collections.unmodifiableMap(hiddenMap) : Collections.emptyMap();
        this.fFrames = frames == null || frames.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IVerbFrame>(frames));
    }

    @Override
    public String getLemma() {
        return this.fLemma;
    }

    @Override
    public POS getPOS() {
        return this.fWordID.getSynsetID().getPOS();
    }

    @Override
    public IWordID getID() {
        return this.fWordID;
    }

    @Override
    public int getLexicalID() {
        return this.fLexID;
    }

    @Override
    public ISenseKey getSenseKey() {
        return this.fSenseKey;
    }

    @Override
    public ISynset getSynset() {
        return this.fSynset;
    }

    @Override
    public Map<IPointer, List<IWordID>> getRelatedMap() {
        return this.wordMap;
    }

    @Override
    public List<IWordID> getRelatedWords(IPointer type) {
        List<IWordID> result = this.wordMap.get(type);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<IWordID> getRelatedWords() {
        return this.wordMap == null ? Collections.emptyList() : this.allWords;
    }

    @Override
    public List<IVerbFrame> getVerbFrames() {
        return this.fFrames;
    }

    @Override
    public AdjMarker getAdjectiveMarker() {
        return this.fAdjMarker;
    }

    public String toString() {
        if (this.fWordID.getSenseNumber() == 0) {
            return "W-" + this.fWordID.getSynsetID().toString().substring(4) + "-?-" + this.fLemma;
        }
        return "W-" + this.fWordID.getSynsetID().toString().substring(4) + "-" + this.fWordID.getSenseNumber() + "-" + this.fLemma;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 31 + ((Object)this.fFrames).hashCode();
        result = 31 * result + ((Object)this.wordMap).hashCode();
        result = 31 * result + this.fWordID.hashCode();
        result = 31 * result + this.fLexID;
        result = 31 * result + (this.fAdjMarker == null ? 0 : this.fAdjMarker.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IWord)) {
            return false;
        }
        IWord other = (IWord)obj;
        if (this.fWordID == null ? other.getID() != null : !this.fWordID.equals(other.getID())) {
            return false;
        }
        if (this.fLexID != other.getLexicalID()) {
            return false;
        }
        if (this.fAdjMarker == null ? other.getAdjectiveMarker() != null : !this.fAdjMarker.equals((Object)other.getAdjectiveMarker())) {
            return false;
        }
        if (!((Object)this.fFrames).equals(other.getVerbFrames())) {
            return false;
        }
        return ((Object)this.wordMap).equals(other.getRelatedMap());
    }

    public static void checkWordNumber(int num) {
        if (Word.isIllegalWordNumber(num)) {
            throw new IllegalArgumentException("'" + num + " is an illegal word number: word numbers are in the closed range [1,255]");
        }
    }

    public static void checkLexicalID(int id) {
        if (Word.isIllegalLexicalID(id)) {
            throw new IllegalArgumentException("'" + id + " is an illegal lexical id: lexical ids are in the closed range [0,15]");
        }
    }

    public static boolean isIllegalLexicalID(int id) {
        return id < 0 || id > 15;
    }

    public static boolean isIllegalWordNumber(int num) {
        return num < 1 || num > 255;
    }

    public static String getLexicalIDForDataFile(int lexID) {
        Word.checkLexicalID(lexID);
        return Integer.toHexString(lexID);
    }

    public static String getLexicalIDForSenseKey(int lexID) {
        Word.checkLexicalID(lexID);
        return lexID < 10 ? lexIDNumStrs[lexID] : Integer.toString(lexID);
    }

    public static String zeroFillWordNumber(int offset) {
        int i;
        if (offset < 0 || 255 < offset) {
            throw new IllegalArgumentException("Word numbers must be non-negative numbers less than two hexidecimal digits long");
        }
        StringBuilder sb = new StringBuilder(2);
        String str = Integer.toHexString(offset);
        int numZeros = 2 - str.length();
        for (i = 0; i < numZeros; ++i) {
            sb.append('0');
        }
        for (i = 0; i < str.length(); ++i) {
            sb.append(Character.toUpperCase(str.charAt(i)));
        }
        return sb.toString();
    }
}

