/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    CoolBar parent;
    Control control;

    public CoolItem(CoolBar parent, int style) {
        this(parent, style, parent.itemCount);
    }

    public CoolItem(CoolBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
        this.updateLayout(this.handle);
        this.setButtonVisibility((byte)2);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_ToolBar();
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void createWidget() {
        super.createWidget();
        int background = OS.Brushes_Transparent();
        OS.Control_Background(this.handle, background);
        OS.GCHandle_Free(background);
    }

    public Point computeSize(int wHint, int hHint) {
        this.checkWidget();
        if (this.isToolBar(this.control)) {
            return this.control.computeSize(-1, -1);
        }
        int template = OS.Control_Template(this.handle);
        int partName = this.createDotNetString("PART_ToolBarPanel", false);
        int part = OS.FrameworkTemplate_FindName(template, partName, this.handle);
        int width = wHint;
        int height = hHint;
        width = Math.max(0, width);
        height = Math.max(0, height);
        int margin = OS.FrameworkElement_Margin(part);
        width = (int)((double)width + (OS.Thickness_Left(margin) + OS.Thickness_Right(margin)));
        height = (int)((double)height + (OS.Thickness_Top(margin) + OS.Thickness_Bottom(margin)));
        OS.GCHandle_Free(partName);
        OS.GCHandle_Free(part);
        OS.GCHandle_Free(margin);
        partName = this.createDotNetString("ToolBarThumb", false);
        part = OS.FrameworkTemplate_FindName(template, partName, this.handle);
        width = (int)((double)width + OS.FrameworkElement_Width(part));
        OS.GCHandle_Free(partName);
        OS.GCHandle_Free(part);
        OS.GCHandle_Free(template);
        return new Point(width, height);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int parentHandle = this.parent.handle;
        int topHandle = this.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(topHandle, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(topHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(topHandle);
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int width = (int)OS.FrameworkElement_MinWidth(this.handle);
        int height = (int)OS.FrameworkElement_MinHeight(this.handle);
        return new Point(width, height);
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getPreferredSize() {
        this.checkWidget();
        return this.getSize();
    }

    public Point getSize() {
        this.checkWidget();
        int width = (int)OS.FrameworkElement_Width(this.handle);
        int height = (int)OS.FrameworkElement_Height(this.handle);
        return new Point(width, height);
    }

    void HandleSizeChanged(int sender, int e) {
        if (this.isToolBar(this.control)) {
            ToolBar toolbar = (ToolBar)this.control;
            boolean overflow = OS.ToolBar_HasOverflowItems(toolbar.handle);
            toolbar.setButtonVisibility(overflow ? (byte)0 : 2);
        } else {
            boolean overflow = OS.ToolBar_HasOverflowItems(this.handle);
            this.setButtonVisibility(overflow ? (byte)0 : 2);
            if (this.control != null) {
                int template = OS.Control_Template(this.handle);
                int partName = this.createDotNetString("PART_ToolBarPanel", false);
                int part = OS.FrameworkTemplate_FindName(template, partName, this.handle);
                int width = (int)OS.FrameworkElement_ActualWidth(part);
                int height = (int)OS.FrameworkElement_ActualHeight(part);
                this.control.setSize(width, height);
                OS.GCHandle_Free(part);
                OS.GCHandle_Free(partName);
                OS.GCHandle_Free(template);
            }
        }
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        OS.FrameworkElement_SizeChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    boolean isToolBar(Control control) {
        if (control == null || control.isDisposed()) {
            return false;
        }
        int type = OS.ToolBar_typeid();
        boolean result = OS.Type_IsInstanceOfType(type, control.handle);
        OS.GCHandle_Free(type);
        return result;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void setButtonVisibility(byte visibility) {
        int overFlowName;
        int template = OS.Control_Template(this.handle);
        int overFlowGrid = OS.FrameworkTemplate_FindName(template, overFlowName = this.createDotNetString("OverflowGrid", false), this.handle);
        if (overFlowGrid != 0) {
            OS.UIElement_Visibility(overFlowGrid, visibility);
            OS.GCHandle_Free(overFlowGrid);
        }
        OS.GCHandle_Free(overFlowName);
        int borderName = this.createDotNetString("MainPanelBorder", false);
        int border = OS.FrameworkTemplate_FindName(template, borderName, this.handle);
        if (border != 0) {
            int right = visibility == 2 ? 0 : 11;
            int margin = OS.gcnew_Thickness(0.0, 0.0, right, 0.0);
            OS.FrameworkElement_Margin(border, margin);
            OS.GCHandle_Free(border);
            OS.GCHandle_Free(margin);
        }
        OS.GCHandle_Free(borderName);
        OS.GCHandle_Free(template);
    }

    public void setControl(Control control) {
        int children;
        int children2;
        ToolBar toolbar;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        int topHandle = this.topHandle();
        int toolbars = OS.ToolBarTray_ToolBars(this.parent.handle);
        int index = OS.IList_IndexOf(toolbars, topHandle);
        int band = OS.ToolBar_Band(topHandle);
        int bandIndex = OS.ToolBar_BandIndex(topHandle);
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        if (oldControl != null) {
            if (this.isToolBar(oldControl)) {
                toolbar = (ToolBar)oldControl;
                toolbar.setThumbVisibility((byte)2);
                toolbar.setButtonVisibility((byte)2);
                OS.IList_Remove(toolbars, toolbar.handle);
                children2 = OS.ToolBarTray_ToolBars(toolbar.trayHandle);
                OS.IList_Add(children2, toolbar.handle);
                OS.GCHandle_Free(children2);
                OS.IList_Insert(toolbars, index, this.handle);
                OS.ToolBar_Band(this.handle, band);
                OS.ToolBar_BandIndex(this.handle, bandIndex);
            } else {
                int controlHandle = oldControl.topHandle();
                int items = OS.ItemsControl_Items(this.handle);
                OS.ItemCollection_Remove(items, controlHandle);
                OS.GCHandle_Free(items);
                children = OS.Panel_Children(this.parent.parentingHandle);
                OS.UIElementCollection_Add(children, controlHandle);
                OS.GCHandle_Free(children);
            }
        }
        if (newControl != null) {
            if (this.isToolBar(newControl)) {
                double minHeight;
                double minWidth;
                double height;
                toolbar = (ToolBar)newControl;
                int controlHandle = toolbar.handle;
                children = OS.ToolBarTray_ToolBars(toolbar.trayHandle);
                OS.IList_Remove(children, controlHandle);
                OS.GCHandle_Free(children);
                OS.IList_Remove(toolbars, this.handle);
                OS.IList_Insert(toolbars, index, controlHandle);
                boolean locked = OS.ToolBarTray_IsLocked(this.parent.handle);
                boolean overflow = OS.ToolBar_HasOverflowItems(controlHandle);
                toolbar.setThumbVisibility(locked ? (byte)2 : 0);
                toolbar.setButtonVisibility(overflow ? (byte)0 : 2);
                OS.ToolBar_Band(controlHandle, band);
                OS.ToolBar_BandIndex(controlHandle, bandIndex);
                double width = OS.FrameworkElement_Width(this.handle);
                if (width > 0.0) {
                    OS.FrameworkElement_Width(controlHandle, width);
                }
                if ((height = OS.FrameworkElement_Height(this.handle)) > 0.0) {
                    OS.FrameworkElement_Height(controlHandle, height);
                }
                if ((minWidth = OS.FrameworkElement_MinWidth(this.handle)) > 0.0) {
                    OS.FrameworkElement_MinWidth(controlHandle, minWidth);
                }
                if ((minHeight = OS.FrameworkElement_MinHeight(this.handle)) > 0.0) {
                    OS.FrameworkElement_MinHeight(controlHandle, minHeight);
                }
                this.updateLayout(controlHandle);
            } else {
                int controlHandle = newControl.topHandle();
                children2 = OS.Panel_Children(this.parent.parentingHandle());
                OS.UIElementCollection_Remove(children2, controlHandle);
                OS.GCHandle_Free(children2);
                int items = OS.ItemsControl_Items(this.handle);
                OS.ItemCollection_Add(items, controlHandle);
                OS.GCHandle_Free(items);
            }
        }
        OS.GCHandle_Free(toolbars);
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        width = Math.max(0, width);
        height = Math.max(0, height);
        OS.FrameworkElement_MinWidth(this.handle, width);
        OS.FrameworkElement_MinHeight(this.handle, height);
        if (this.isToolBar(this.control)) {
            OS.FrameworkElement_MinWidth(this.control.handle, width);
            OS.FrameworkElement_MinHeight(this.control.handle, height);
        }
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setPreferredSize(int width, int height) {
        this.checkWidget();
        this.setSize(width, height);
    }

    public void setPreferredSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setPreferredSize(size.x, size.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        width = Math.max(0, width);
        height = Math.max(0, height);
        OS.FrameworkElement_Width(this.handle, width);
        OS.FrameworkElement_Height(this.handle, height);
        if (this.isToolBar(this.control)) {
            OS.FrameworkElement_Width(this.control.handle, width);
            OS.FrameworkElement_Height(this.control.handle, height);
        }
    }

    public void setSize(Point size) {
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    int topHandle() {
        if (this.isToolBar(this.control)) {
            return this.control.handle;
        }
        return this.handle;
    }
}

