/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text = "";
    Image image;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    void createHandle() {
        this.state |= 0x100;
        if ((this.style & 2) != 0) {
            int separator;
            this.handle = OS.gcnew_UserControl();
            if (this.handle == 0) {
                this.error(2);
            }
            if ((separator = OS.gcnew_Label()) == 0) {
                this.error(2);
            }
            OS.ContentControl_Content(this.handle, separator);
            if ((this.style & 0x200) != 0) {
                OS.FrameworkElement_Width(separator, OS.SystemParameters_ThinVerticalBorderWidth());
                OS.Control_HorizontalContentAlignment(this.handle, 1);
                OS.Control_VerticalContentAlignment(this.handle, 3);
            } else {
                OS.FrameworkElement_Height(separator, OS.SystemParameters_ThinHorizontalBorderHeight());
                OS.Control_HorizontalContentAlignment(this.handle, 3);
                OS.Control_VerticalContentAlignment(this.handle, 1);
            }
            int brush = OS.SystemColors_ActiveBorderBrush();
            OS.Control_Background(separator, brush);
            OS.GCHandle_Free(brush);
            OS.GCHandle_Free(separator);
        } else {
            this.handle = OS.gcnew_Label();
            if (this.handle == 0) {
                this.error(2);
            }
            int value = 0;
            if ((this.style & 0x1000000) != 0) {
                value = 1;
            }
            if ((this.style & 0x20000) != 0) {
                value = 2;
            }
            OS.Control_HorizontalContentAlignment(this.handle, value);
            int margin = OS.gcnew_Thickness(0.0, 0.0, 0.0, 0.0);
            OS.Control_Padding(this.handle, margin);
            OS.GCHandle_Free(margin);
        }
    }

    int defaultBackground() {
        return 0;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        int accessText = OS.ContentControl_Content(this.handle);
        boolean result = super.mnemonicMatch(accessText, key);
        OS.GCHandle_Free(accessText);
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int value = 0;
        if ((this.style & 0x1000000) != 0) {
            value = 1;
        }
        if ((this.style & 0x20000) != 0) {
            value = 2;
        }
        OS.Control_HorizontalContentAlignment(this.handle, value);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        int imageHandle = OS.gcnew_Image();
        OS.Image_Stretch(imageHandle, 0);
        OS.Image_Source(imageHandle, image != null ? image.handle : 0);
        OS.ContentControl_Content(this.handle, imageHandle);
        OS.GCHandle_Free(imageHandle);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        int ptr = this.createDotNetString(this.text, true);
        int accessText = OS.gcnew_AccessText();
        if (accessText == 0) {
            this.error(2);
        }
        if ((this.style & 0x40) != 0) {
            OS.AccessText_TextWrapping(accessText, 0);
        }
        OS.AccessText_Text(accessText, ptr);
        OS.ContentControl_Content(this.handle, accessText);
        OS.GCHandle_Free(ptr);
        OS.GCHandle_Free(accessText);
    }
}

