/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    void createHandle() {
        if ((this.style & 2) != 0) {
            this.handle = OS.gcnew_Separator();
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = OS.gcnew_MenuItem();
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x30) != 0) {
                OS.MenuItem_IsCheckable(this.handle, true);
            }
        }
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null) {
            this.menu.fixMenus(newParent);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return 0;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.UIElement_IsVisible(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(this.handle, point, this.parent.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        return new Rectangle(x, y, width, height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.UIElement_IsEnabled(this.handle);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.MenuItem_IsChecked(this.handle);
    }

    void HandleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.style & 0x10) != 0 && (this.parent.style & 0x400000) == 0) {
            if (this.parent.selected == this) {
                OS.MenuItem_IsChecked(this.handle, true);
                return;
            }
            if (this.parent.selected != null) {
                OS.MenuItem_IsChecked(this.parent.selected.handle, false);
            }
            this.parent.selected = this;
        }
        Event event = new Event();
        this.setInputState(event, 13, 0, 0);
        this.postEvent(13, event);
    }

    void HandleSubmenuOpened(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.menu != null) {
            this.menu.sendEvent(22);
        }
    }

    void HandleSubmenuClosed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.menu != null) {
            this.menu.sendEvent(23);
        }
    }

    void hookEvents() {
        if ((this.style & 2) != 0) {
            return;
        }
        super.hookEvents();
        if ((this.style & 0x40) == 0) {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            if (handler == 0) {
                this.error(2);
            }
            OS.MenuItem_Click(this.handle, handler);
            OS.GCHandle_Free(handler);
        } else {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleSubmenuOpened");
            if (handler == 0) {
                this.error(2);
            }
            OS.MenuItem_SubmenuOpened(this.handle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleSubmenuClosed");
            if (handler == 0) {
                this.error(2);
            }
            OS.MenuItem_SubmenuClosed(this.handle, handler);
            OS.GCHandle_Free(handler);
        }
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseMenu() {
        this.setMenu(null);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.UIElement_IsEnabled(this.handle, enabled);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int img = OS.gcnew_Image();
            if (img == 0) {
                this.error(2);
            }
            OS.Image_Source(img, image.handle);
            OS.Image_Stretch(img, 0);
            OS.MenuItem_Icon(this.handle, img);
            OS.GCHandle_Free(img);
        } else {
            OS.MenuItem_Icon(this.handle, 0);
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            Menu oldMenu;
            if (menu.cascade != null) {
                this.error(32);
            }
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
            if ((oldMenu = this.menu) == menu) {
                return;
            }
            if (oldMenu != null) {
                oldMenu.cascade = null;
            }
            this.menu = menu;
            OS.ItemsControl_ItemsSource(this.handle, menu.handle);
            menu.cascade = this;
        } else {
            OS.ItemsControl_ItemsSource(this.handle, 0);
            if (this.menu != null) {
                this.menu.cascade = null;
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.MenuItem_IsChecked(this.handle, selected);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        String accelString = null;
        int index = string.indexOf(9);
        if (index != -1) {
            accelString = string.substring(index + 1, string.length());
            string = string.substring(0, index);
        }
        int ptr = this.createDotNetString(string, true);
        OS.HeaderedItemsControl_Header(this.handle, ptr);
        OS.GCHandle_Free(ptr);
        if (accelString != null) {
            ptr = this.createDotNetString(accelString, false);
            OS.MenuItem_InputGestureText(this.handle, ptr);
            OS.GCHandle_Free(ptr);
        }
    }
}

