/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width = (int)((double)width + OS.SystemParameters_HorizontalScrollBarButtonWidth() * 10.0);
            height = (int)((double)height + OS.SystemParameters_HorizontalScrollBarHeight() * 2.0);
        } else {
            width = (int)((double)width + OS.SystemParameters_VerticalScrollBarWidth() * 2.0);
            height = (int)((double)height + OS.SystemParameters_VerticalScrollBarButtonHeight() * 10.0);
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x100;
        this.handle = OS.gcnew_Slider();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            OS.Slider_Orientation(this.handle, 1);
        }
        OS.RangeBase_Maximum(this.handle, 100.0);
        OS.RangeBase_LargeChange(this.handle, 10.0);
        OS.RangeBase_SmallChange(this.handle, 1.0);
        OS.Slider_TickFrequency(this.handle, 10.0);
        OS.Slider_TickPlacement(this.handle, 3);
    }

    int defaultBackground() {
        return OS.SystemColors_ControlColor;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_SmallChange(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)OS.RangeBase_Maximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.RangeBase_Minimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_LargeChange(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.RangeBase_Value(this.handle);
    }

    void HandleValueChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.postEvent(13);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedPropertyChangedEventHandler(this.jniRef, "HandleValueChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.RangeBase_ValueChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment < 1) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        if (increment > maximum - minimum) {
            return;
        }
        OS.RangeBase_SmallChange(this.handle, increment);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        if (minimum >= 0 && minimum < value) {
            OS.RangeBase_Maximum(this.handle, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        if (value >= 0 && value < maximum) {
            OS.RangeBase_Minimum(this.handle, value);
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        if (pageIncrement > maximum - minimum) {
            return;
        }
        OS.RangeBase_LargeChange(this.handle, pageIncrement);
        OS.Slider_TickFrequency(this.handle, pageIncrement);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.RangeBase_Value(this.handle, value);
    }
}

