/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean ignoreFocus;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width = (int)((double)width + OS.SystemParameters_HorizontalScrollBarButtonWidth() * 10.0);
            height = (int)((double)height + OS.SystemParameters_HorizontalScrollBarHeight());
        } else {
            width = (int)((double)width + OS.SystemParameters_VerticalScrollBarWidth());
            height = (int)((double)height + OS.SystemParameters_VerticalScrollBarButtonHeight() * 10.0);
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.handle = OS.gcnew_ScrollBar();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x100) != 0) {
            OS.ScrollBar_Orientation(this.handle, 0);
        }
        OS.RangeBase_Maximum(this.handle, 100.0);
        OS.RangeBase_LargeChange(this.handle, 10.0);
        OS.RangeBase_SmallChange(this.handle, 1.0);
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_SmallChange(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        return maximum + viewSize;
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.RangeBase_Minimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_LargeChange(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.RangeBase_Value(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return (int)OS.ScrollBar_ViewportSize(this.handle);
    }

    void HandleScroll(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        Event event = new Event();
        switch (OS.ScrollEventArgs_ScrollEventType(e)) {
            case 0: {
                return;
            }
            case 7: {
                event.detail = 0;
                break;
            }
            case 8: {
                event.detail = 1;
                break;
            }
            case 1: {
                event.detail = 0x1000007;
                break;
            }
            case 4: {
                event.detail = 0x1000008;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
                break;
            }
            case 6: {
                event.detail = 0x1000002;
                break;
            }
            case 5: {
                event.detail = 0x1000001;
            }
        }
        this.postEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_ScrollEventHandler(this.jniRef, "HandleScroll");
        if (handler == 0) {
            this.error(2);
        }
        OS.ScrollBar_Scroll(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.RangeBase_SmallChange(this.handle, value);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        if (value <= minimum) {
            return;
        }
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        if (value - minimum < viewSize) {
            viewSize = value - minimum;
            OS.ScrollBar_ViewportSize(this.handle, viewSize);
        }
        OS.RangeBase_Maximum(this.handle, value - viewSize);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle) + viewSize;
        if (value >= maximum) {
            return;
        }
        if (maximum - value < viewSize) {
            viewSize = maximum - value;
            OS.RangeBase_Maximum(this.handle, maximum - viewSize);
            OS.ScrollBar_ViewportSize(this.handle, viewSize);
        }
        OS.RangeBase_Minimum(this.handle, value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.RangeBase_LargeChange(this.handle, value);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.RangeBase_Value(this.handle, value);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle) + viewSize;
        value = Math.min(value, maximum - minimum);
        OS.RangeBase_Maximum(this.handle, maximum - value);
        OS.ScrollBar_ViewportSize(this.handle, value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        OS.RangeBase_Minimum(this.handle, minimum);
        OS.RangeBase_Maximum(this.handle, maximum - thumb);
        OS.ScrollBar_ViewportSize(this.handle, thumb);
        OS.RangeBase_Value(this.handle, selection);
        OS.RangeBase_LargeChange(this.handle, pageIncrement);
        OS.RangeBase_SmallChange(this.handle, increment);
    }
}

