/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;

public abstract class ProvisioningOperation {
    private String label;

    public ProvisioningOperation(String label) {
        this.label = label;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        IStatus status;
        try {
            status = this.doExecute(monitor, uiInfo);
        }
        catch (ProvisionException e) {
            throw new ExecutionException(NLS.bind((String)ProvUIMessages.ProvisioningOperation_ExecuteErrorTitle, (Object)this.label, (Object)((Object)e)));
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return status;
    }

    protected abstract IStatus doExecute(IProgressMonitor var1, IAdaptable var2) throws ProvisionException;

    protected IStatus okStatus() {
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean runInBackground() {
        return false;
    }

    public boolean isUser() {
        return true;
    }
}

