/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement;

import edu.mit.story.core.agreement.DoubleResult;
import edu.mit.story.core.agreement.IntResult;
import edu.mit.story.core.rep.IRep;

public class FMeasureResult
extends DoubleResult {
    public FMeasureResult(String sourceName, String targetName, int inSourceOnly, int inTargetOnly, int inBoth, IRep rep) {
        super("F_1 Measure", FMeasureResult.computeFMeasure(inSourceOnly, inTargetOnly, inBoth), rep, new PrecisionResult(inSourceOnly, inBoth, rep), new RecallResult(inTargetOnly, inBoth, rep), new IntResult(String.valueOf(sourceName) + " only", inSourceOnly, rep), new IntResult(String.valueOf(targetName) + " only", inTargetOnly, rep), new IntResult(String.valueOf(sourceName) + " and " + targetName, inBoth, rep));
    }

    public static double computePrecision(int sourceCount, int bothCount) {
        if (sourceCount == 0) {
            return 1.0;
        }
        return (double)bothCount / (double)(bothCount + sourceCount);
    }

    public static double computeRecall(int targetCount, int bothCount) {
        if (bothCount == 0) {
            return 1.0;
        }
        return (double)bothCount / (double)(bothCount + targetCount);
    }

    public static double computeFMeasure(int sourceCount, int targetCount, int bothCount) {
        double p = FMeasureResult.computePrecision(sourceCount, bothCount);
        double r = FMeasureResult.computeRecall(targetCount, bothCount);
        return FMeasureResult.computeFMeasure(p, r);
    }

    public static double computeFMeasure(double precision, double recall) {
        return 2.0 * precision * recall / (precision + recall);
    }

    public static class PrecisionResult
    extends DoubleResult {
        public PrecisionResult(int sourceCount, int bothCount, IRep rep) {
            super("Precision", FMeasureResult.computePrecision(sourceCount, bothCount), rep);
        }
    }

    public static class RecallResult
    extends DoubleResult {
        public RecallResult(int targetCount, int bothCount, IRep rep) {
            super("Recall", FMeasureResult.computeRecall(targetCount, bothCount), rep);
        }
    }
}

