/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import edu.mit.story.core.datamodel.IBatchPairModel;
import edu.mit.story.core.datamodel.IOutputTargetModel;
import edu.mit.story.core.datamodel.OutputTargetModel;
import edu.mit.story.core.datamodel.ResourcePairModel;
import edu.mit.story.core.measure.StoryPairExtractor;
import edu.mit.story.core.notify.INotifyTableCallback;
import edu.mit.story.core.notify.NotifyingTable;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.ResourceComparator;
import edu.mit.story.core.validation.Message;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPairModel
extends ResourcePairModel
implements IBatchPairModel,
ChangeListener,
INotifyTableCallback<IFile, IFile, Boolean> {
    private final IOutputTargetModel outputTargetModel;
    private final Table<IFile, IFile, Boolean> resourcePairs;
    private final SortedSet<IRep> sourceReps = new TreeSet<IRep>();
    private final SortedSet<IRep> targetReps = new TreeSet<IRep>();
    private final SortedSet<IRep> extSourceReps = Collections.unmodifiableSortedSet(this.sourceReps);
    private final SortedSet<IRep> extTargetReps = Collections.unmodifiableSortedSet(this.targetReps);

    public BatchPairModel() {
        Object table = TreeBasedTable.create((Comparator)ResourceComparator.getInstance(), (Comparator)ResourceComparator.getInstance());
        table = new NotifyingTable<IFile, IFile, Boolean>((Table<IFile, IFile, Boolean>)table, this);
        OutputTargetModel model = new OutputTargetModel();
        model.addChangeListener(this);
        this.resourcePairs = table;
        this.outputTargetModel = model;
    }

    @Override
    public void mappingAdded(IFile row, IFile col, Boolean value) {
        this.fileSetChanged();
        this.fireChanged();
    }

    @Override
    public void mappingModified(IFile row, IFile col, Boolean newValue, Boolean oldValue) {
        this.fileSetChanged();
        this.fireChanged();
    }

    @Override
    public void mappingRemoved(IFile row, IFile col, Boolean value) {
        this.fileSetChanged();
        this.fireChanged();
    }

    protected void fileSetChanged() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChanged();
    }

    @Override
    public void dispose() {
        this.outputTargetModel.removeChangeListener(this);
        this.outputTargetModel.dispose();
    }

    @Override
    public boolean setSource(File file) {
        boolean result = super.setSource(file);
        if (result) {
            this.recalculateTargetPairs();
        }
        return result;
    }

    @Override
    public boolean setTarget(File file) {
        boolean result = super.setTarget(file);
        if (result) {
            this.recalculateTargetPairs();
        }
        return result;
    }

    protected void recalculateTargetPairs() {
        try {
            this.suppressNotifications();
            this.resourcePairs.clear();
            this.sourceReps.clear();
            this.targetReps.clear();
            File src = this.getSourceFile();
            File tgt = this.getTargetFile();
            if (src == null || tgt == null) {
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath p = Path.fromOSString((String)src.getAbsolutePath());
            p = p.removeFirstSegments(p.matchingFirstSegments(root.getLocation()));
            IResource srcRes = root.findMember(p);
            p = Path.fromOSString((String)tgt.getAbsolutePath());
            p = p.removeFirstSegments(p.matchingFirstSegments(root.getLocation()));
            IResource tgtRes = root.findMember(p);
            Map<IFile, IFile> pairs = StoryPairExtractor.getInstance().getPairs(srcRes, tgtRes, null);
            for (Map.Entry<IFile, IFile> pair : pairs.entrySet()) {
                this.resourcePairs.put((Object)pair.getKey(), (Object)pair.getValue(), (Object)true);
            }
        }
        finally {
            this.allowNotifications();
        }
    }

    @Override
    public Table<IFile, IFile, Boolean> getResourcePairs() {
        return this.resourcePairs;
    }

    @Override
    public File getOutputFile() {
        return this.outputTargetModel.getOutputFile();
    }

    @Override
    public void setOutput(File file) {
        this.outputTargetModel.setOutput(file);
    }

    @Override
    protected void internalClear() {
        super.internalClear();
        this.outputTargetModel.clear();
    }

    @Override
    protected IMessageProvider calculateMessage() {
        IMessageProvider m = super.calculateMessage();
        if (m.getMessageType() < this.outputTargetModel.getMessageType()) {
            return new Message(this.outputTargetModel);
        }
        return m;
    }

    @Override
    public SortedSet<IRep> getSupportedSource() {
        return this.extSourceReps;
    }

    @Override
    public SortedSet<IRep> getSupportedTarget() {
        return this.extTargetReps;
    }
}

