/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.IRepSetsModel;
import edu.mit.story.core.datamodel.ITagModel;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.core.notify.INotifyMapCallback;
import edu.mit.story.core.notify.NotifyingSortedMap;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.validation.Message;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeModel
extends AbstractViewModel
implements IMergeModel {
    private final IRepSetsModel repModel;
    private final ITagModel tagModel;
    private boolean deleteTimings = true;
    private boolean addExactAlignMergeTags = false;
    INotifyMapCallback<IRep, Boolean> callback = new INotifyMapCallback<IRep, Boolean>(){

        @Override
        public void mappingAdded(IRep key, Boolean value) {
            MergeModel.this.updateOutputReps();
        }

        @Override
        public void mappingModified(IRep key, Boolean newValue, Boolean oldValue) {
            MergeModel.this.updateOutputReps();
        }

        @Override
        public void mappingRemoved(IRep key, Boolean value) {
            MergeModel.this.updateOutputReps();
        }
    };
    private final SortedMap<IRep, Boolean> sourceReps = new NotifyingSortedMap<IRep, Boolean>(this.callback);
    private final SortedMap<IRep, Boolean> targetReps = new NotifyingSortedMap<IRep, Boolean>(this.callback);
    private final SortedMap<IRep, IMergeModel.Action> outputReps = new TreeMap<IRep, IMergeModel.Action>();

    public MergeModel(IRepSetsModel repModel, ITagModel tagModel) {
        if (repModel == null) {
            throw new NullPointerException();
        }
        this.repModel = repModel;
        this.repModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MergeModel.this.targetModelChanged();
            }
        });
        if (tagModel == null) {
            throw new NullPointerException();
        }
        this.tagModel = tagModel;
        if (repModel != tagModel) {
            this.tagModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MergeModel.this.targetModelChanged();
                }
            });
        }
        this.targetModelChanged();
    }

    protected void targetModelChanged() {
        this.sourceReps.clear();
        this.targetReps.clear();
        for (IRep rep : this.repModel.getSupportedSource()) {
            this.sourceReps.put(rep, rep.isTransferable());
        }
        for (IRep rep : this.repModel.getSupportedTarget()) {
            this.targetReps.put(rep, true);
        }
        this.updateOutputReps();
        this.fireChanged();
    }

    protected void updateOutputReps() {
        TreeSet<IRep> srcTransfer = new TreeSet<IRep>();
        for (Map.Entry<IRep, Boolean> e : this.sourceReps.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            srcTransfer.add(e.getKey());
        }
        TreeSet<IRep> tgtTransfer = new TreeSet<IRep>();
        for (Map.Entry<IRep, Boolean> e : this.targetReps.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            tgtTransfer.add(e.getKey());
        }
        IRepSet srcUnchecked = RepUtils.closeWithAntecedents(srcTransfer);
        srcUnchecked.removeAll(srcTransfer);
        TreeSet<IRep> allReps = new TreeSet<IRep>();
        allReps.addAll(this.sourceReps.keySet());
        allReps.addAll(this.targetReps.keySet());
        for (IRep rep : allReps) {
            IMergeModel.Action origin = this.getOrigin(rep, srcTransfer, srcUnchecked, tgtTransfer);
            this.outputReps.put(rep, origin);
        }
    }

    protected IMergeModel.Action getOrigin(IRep rep, Set<IRep> srcTransfer, Set<IRep> srcUnchecked, Set<IRep> tgtTransfer) {
        boolean srcChecked = srcTransfer.contains(rep);
        boolean srcNeededNotChecked = srcUnchecked.contains(rep);
        boolean tgtChecked = tgtTransfer.contains(rep);
        if (srcChecked) {
            if (tgtChecked) {
                return IMergeModel.Action.MERGE;
            }
            return IMergeModel.Action.TRANSFER_FROM_SOURCE;
        }
        if (srcNeededNotChecked) {
            if (tgtChecked) {
                return IMergeModel.Action.ALIGN;
            }
            return IMergeModel.Action.TRANSFER_FROM_SOURCE;
        }
        if (tgtChecked) {
            return IMergeModel.Action.TRANSFER_FROM_TARGET;
        }
        return IMergeModel.Action.IGNORE;
    }

    @Override
    public void modify(boolean source, boolean add, IRep rep) {
        if (add && source) {
            this.addToSource(rep);
        } else if (add && !source) {
            this.addToTarget(rep);
        } else if (!add && source) {
            this.removeFromSource(rep);
        } else if (!add && !source) {
            this.removeFromTarget(rep);
        } else {
            throw new IllegalStateException("There has been a rupture in the space-time continuum");
        }
    }

    protected void addToTarget(IRep rep) {
        for (IRep ante : RepUtils.getAllAntecedents(rep)) {
            this.targetReps.put(ante, Boolean.TRUE);
        }
        this.targetReps.put(rep, Boolean.TRUE);
        this.ensureConsistency();
        this.fireChanged();
    }

    protected void addToSource(IRep rep) {
        IRepSet antes = RepUtils.getAllAntecedents(rep);
        for (IRep r : antes) {
            if (!this.targetReps.containsKey(r) || ((Boolean)this.targetReps.get(r)).booleanValue()) continue;
            this.sourceReps.put(r, Boolean.TRUE);
        }
        this.sourceReps.put(rep, Boolean.TRUE);
        IRepSet deps = RepUtils.getAllDependents(rep, (IRepSupporter)new RepSet(this.sourceReps.keySet()));
        for (IRep dep : deps) {
            if (!((Boolean)this.sourceReps.get(dep)).booleanValue()) continue;
            IRepSet depAntes = RepUtils.getAllAntecedents(dep);
            depAntes.removeAll(antes);
            for (IRep ante : depAntes) {
                this.sourceReps.put(ante, Boolean.TRUE);
            }
        }
        this.ensureConsistency();
        this.fireChanged();
    }

    protected void removeFromSource(IRep rep) {
        if (this.sourceReps.containsKey(rep)) {
            this.sourceReps.put(rep, false);
        }
        this.ensureConsistency();
        this.fireChanged();
    }

    protected void removeFromTarget(IRep rep) {
        for (IRep dep : RepUtils.getAllDependents(rep, (IRepSupporter)new RepSet(this.targetReps.keySet()))) {
            if (!this.targetReps.containsKey(dep)) continue;
            this.targetReps.put(dep, false);
        }
        this.targetReps.put(rep, Boolean.FALSE);
        this.ensureConsistency();
        this.fireChanged();
    }

    protected void ensureConsistency() {
        for (Map.Entry<IRep, Boolean> entry : this.sourceReps.entrySet()) {
            IMergeModel.Action action;
            this.updateOutputReps();
            IRepSet anteReps = RepUtils.getAllAntecedents(entry.getKey());
            for (IRep ante : anteReps) {
                action = (IMergeModel.Action)((Object)this.outputReps.get(ante));
                if (action != IMergeModel.Action.IGNORE && action != IMergeModel.Action.TRANSFER_FROM_TARGET) continue;
                entry.setValue(Boolean.FALSE);
            }
            this.updateOutputReps();
            action = (IMergeModel.Action)((Object)this.outputReps.get(entry.getKey()));
            if (action != IMergeModel.Action.ALIGN) continue;
            for (IRep ante : anteReps) {
                this.sourceReps.put(ante, false);
            }
        }
        this.updateOutputReps();
    }

    @Override
    public SortedMap<IRep, Boolean> getTargetTransferReps() {
        return this.targetReps;
    }

    @Override
    public SortedMap<IRep, Boolean> getSourceTransferReps() {
        return this.sourceReps;
    }

    @Override
    public SortedMap<IRep, IMergeModel.Action> getOutputReps() {
        return this.outputReps;
    }

    @Override
    public boolean getDeleteTimings() {
        return this.deleteTimings;
    }

    @Override
    public void setDeleteTimings(boolean value) {
        this.deleteTimings = value;
        this.fireChanged();
    }

    @Override
    public boolean getAddExactAlignMergeTags() {
        return this.addExactAlignMergeTags;
    }

    @Override
    public void setAddExactAlignMergeTags(boolean value) {
        this.addExactAlignMergeTags = value;
        this.fireChanged();
    }

    @Override
    protected void internalClear() {
        this.sourceReps.clear();
        this.targetReps.clear();
        this.outputReps.clear();
    }

    @Override
    public boolean isCleared() {
        if (!this.sourceReps.isEmpty()) {
            return false;
        }
        if (!this.targetReps.isEmpty()) {
            return false;
        }
        return this.outputReps.isEmpty();
    }

    @Override
    protected IMessageProvider calculateMessage() {
        return new Message(this.repModel);
    }

    @Override
    public SortedSet<IRep> getSupportedSource() {
        return this.repModel.getSupportedSource();
    }

    @Override
    public SortedSet<IRep> getSupportedTarget() {
        return this.repModel.getSupportedTarget();
    }

    @Override
    public String getSourceTag() {
        return this.tagModel.getSourceTag();
    }

    @Override
    public String getTargetTag() {
        return this.tagModel.getTargetTag();
    }

    @Override
    public void setSourceTag(String tag) {
        this.tagModel.setSourceTag(tag);
    }

    @Override
    public void setTargetTag(String tag) {
        this.tagModel.setTargetTag(tag);
    }
}

