/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.element;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.ArrayUtils;
import edu.mit.story.core.util.IUtilityClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoryElementUtils
implements IUtilityClass {
    private StoryElementUtils() {
    }

    public static Set<IStoryElement> getStoryElements(Collection<?> objects) {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return null;
        }
        HashSet<IStoryElement> descs = null;
        for (Object obj : objects) {
            if (!(obj instanceof IStoryElement)) continue;
            if (descs == null) {
                descs = new HashSet<IStoryElement>();
            }
            descs.add((IStoryElement)obj);
        }
        return descs;
    }

    public static IDesc[] getDescriptions(Collection<IStoryElement> objs) {
        if (objs == null) {
            return ArrayUtils.emptyArray(IDesc.class);
        }
        if (objs.isEmpty()) {
            return ArrayUtils.emptyArray(IDesc.class);
        }
        HashSet<IDesc> descs = null;
        for (IStoryElement obj : objs) {
            if (obj.getImplementationCode() != 5) continue;
            if (descs == null) {
                descs = new HashSet<IDesc>();
            }
            descs.add((IDesc)((Object)obj));
        }
        if (descs == null) {
            return ArrayUtils.emptyArray(IDesc.class);
        }
        return descs.toArray(new IDesc[descs.size()]);
    }

    public static IRep[] getRepresentations(Collection<IStoryElement> objs) {
        if (objs == null) {
            return ArrayUtils.emptyArray(IRep.class);
        }
        if (objs.isEmpty()) {
            return ArrayUtils.emptyArray(IRep.class);
        }
        HashSet<IRep> reps = null;
        for (IStoryElement obj : objs) {
            if (obj.getImplementationCode() != 1) continue;
            if (reps == null) {
                reps = new HashSet<IRep>();
            }
            reps.add((IRep)obj);
        }
        if (reps == null) {
            return ArrayUtils.emptyArray(IRep.class);
        }
        return reps.toArray(new IRep[reps.size()]);
    }
}

