/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDescriptionsChange
extends AbstractModelChange {
    public final List<IDesc> addList;

    public AddDescriptionsChange(IDesc d) {
        super(StoryMessages.CHANGE_NAME_AddDescriptions);
        this.addList = d == null ? Collections.emptyList() : Collections.singletonList(d);
    }

    public AddDescriptionsChange(Collection<? extends IDesc> ds) {
        super(StoryMessages.CHANGE_NAME_AddDescriptions);
        this.addList = ds == null || ds.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IDesc>(ds));
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
        ArrayList<IDesc> added = new ArrayList<IDesc>(this.addList.size());
        IStoryData data = provider.getData();
        for (IDesc desc : this.addList) {
            if (!data.add(desc)) continue;
            added.add(desc);
            Iterator i = data.getMetadata().iterator();
            while (i.hasNext()) {
                IMetaDesc metaDesc = (IMetaDesc)i.next();
                if (metaDesc.getDescriptionID() != desc.getID()) continue;
                i.remove();
            }
        }
        if (added.isEmpty()) {
            return null;
        }
        Collections.reverse(added);
        RemoveDescriptionsChange undo = new RemoveDescriptionsChange(added);
        DescMultiSet multiSet = new DescMultiSet(added);
        TreeMap<IRep, Change> changeMap = new TreeMap<IRep, Change>();
        Iterator<IDescSet> i = multiSet.descSetIterator();
        while (i.hasNext()) {
            IDescSet descSet = i.next();
            changeMap.put(descSet.getRep(), new Change(Flag.DESC_ADDED, descSet));
        }
        return new StoryChangeEvent(source, provider, changeMap, this, undo);
    }
}

