/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveMetadataChange
extends AbstractModelChange {
    private final Set<IMetaRep> metaReps;
    private final IMetaDataMap metadata;

    public RemoveMetadataChange() {
        super("Delete All Metadata");
        this.metaReps = Collections.emptySet();
        this.metadata = null;
    }

    public RemoveMetadataChange(IMetaDesc<?> d) {
        this((Iterable<? extends IMetaDesc<?>>)Collections.singleton(d));
    }

    public RemoveMetadataChange(IMetaRep metaRep) {
        super("Delete " + metaRep.getName() + " Metadata");
        if (metaRep == null) {
            throw new NullPointerException();
        }
        this.metaReps = Collections.singleton(metaRep);
        this.metadata = null;
    }

    public RemoveMetadataChange(Collection<? extends IMetaRep> metaReps) {
        super("Delete " + metaReps.size() + " Metadata reps");
        if (metaReps == null) {
            throw new NullPointerException();
        }
        this.metaReps = Collections.unmodifiableSet(new HashSet<IMetaRep>(metaReps));
        this.metadata = null;
    }

    public RemoveMetadataChange(Iterable<? extends IMetaDesc<?>> c) {
        super("Delete Metadata");
        this.metaReps = Collections.emptySet();
        this.metadata = new MetaDataMap(c);
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        LinkedHashMap changes = new LinkedHashMap();
        if (this.metaReps.isEmpty() && this.metadata == null) {
            this.deleteAll(model, changes);
        } else if (!this.metaReps.isEmpty()) {
            this.deleteReps(model, changes);
        } else if (this.metadata != null) {
            this.deleteDescs(model, changes);
        }
        if (changes.isEmpty()) {
            return null;
        }
        StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(source, model);
        integrator.metadataRemoved(changes);
        return integrator.asEvent();
    }

    protected void deleteAll(IMutableStoryModel model, Map<IMetaDesc<?>, IHasPosition> changes) {
        for (IMetaDataSet set : model.getData().getMetadata().values()) {
            this.clear(set, changes, model);
        }
        for (IDesc d : model.getData()) {
            for (IMetaDataSet set : d.getMetaData().values()) {
                this.clear(set, changes, d);
            }
        }
    }

    protected void deleteReps(IMutableStoryModel model, Map<IMetaDesc<?>, IHasPosition> changes) {
        for (IMetaRep metaRep : this.metaReps) {
            this.deleteRep(model, metaRep, changes);
        }
    }

    protected void deleteRep(IMutableStoryModel model, IMetaRep metaRep, Map<IMetaDesc<?>, IHasPosition> changes) {
        this.clear(model.getData().getMetadata().get(metaRep), changes, model);
        for (IDesc d : model.getData()) {
            this.clear(d.getMetaData().get(metaRep), changes, d);
        }
    }

    protected void clear(IMetaDataSet<?> ds, Map<IMetaDesc<?>, IHasPosition> changes, IHasPosition target) {
        if (ds == null) {
            return;
        }
        Iterator i = ds.iterator();
        while (i.hasNext()) {
            changes.put((IMetaDesc)i.next(), target);
            i.remove();
        }
    }

    protected void deleteDescs(IMutableStoryModel model, Map<IMetaDesc<?>, IHasPosition> changes) {
        IStoryData data = model.getData();
        for (IMetaDataSet set : this.metadata.values()) {
            for (IMetaDesc md : set) {
                IDesc d;
                if (md.getDescriptionID() >= 0L && (d = data.getDescriptions(md.getRep()).getDescription(md.getDescriptionID())) != null) {
                    d.getMetaData().removeDesc(md);
                    changes.put(md, d);
                    continue;
                }
                data.getMetadata().addDesc(md);
                changes.put(md, model);
            }
        }
    }
}

