/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import edu.mit.story.core.notify.ChangeListenerList;
import edu.mit.story.core.notify.IChangeNotifier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;

public class ChangeNotifier
implements IChangeNotifier {
    protected final ChangeListenerList listeners = new ChangeListenerList();
    private final Lock suppressionLock = new ReentrantLock();
    private Multiset<Object> suppressionCount = HashMultiset.create();
    private boolean notificationsPending = false;

    protected void notifyChangeListeners() {
        this.notifyChangeListeners(this);
    }

    public void notifyChangeListeners(Object source) {
        this.notifyChangeListeners(new ChangeEvent(source));
    }

    public void notifyChangeListeners(final ChangeEvent e) {
        if (e == null) {
            throw new NullPointerException();
        }
        try {
            this.suppressionLock.lock();
            this.notificationsPending = true;
            if (this.suppressionCount.isEmpty()) {
                ChangeListener[] changeListenerArray = this.listeners.getListeners();
                int n = changeListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeListener cl;
                    final ChangeListener l = cl = changeListenerArray[n2];
                    SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            l.stateChanged(e);
                        }
                    });
                    ++n2;
                }
                this.notificationsPending = false;
            }
        }
        finally {
            this.suppressionLock.unlock();
        }
    }

    public void suppressNotifications() {
        try {
            this.suppressionLock.lock();
            this.suppressionCount.add(null);
        }
        finally {
            this.suppressionLock.unlock();
        }
    }

    public void allowNotifications() {
        try {
            this.suppressionLock.lock();
            this.suppressionCount.remove(null);
            if (this.notificationsPending) {
                this.notifyChangeListeners();
            }
        }
        finally {
            this.suppressionLock.unlock();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

