/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IFreeConfiguration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeConfiguration
extends HashMap<String, String>
implements IFreeConfiguration {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String desc;
    private final Map<String, IConfiguration> configMap;

    public FreeConfiguration(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.name = "Free Configuration";
        this.desc = "";
        this.configMap = new ConfigMap();
    }

    public FreeConfiguration(IDescriptor desc) {
        this.id = desc.getID();
        this.name = desc.getName();
        this.desc = desc.getDescription();
        this.configMap = new ConfigMap();
    }

    public FreeConfiguration(IConfiguration srcConfig) {
        super(srcConfig);
        this.id = srcConfig.getID();
        this.name = srcConfig.getName();
        this.desc = srcConfig.getDescription();
        this.configMap = new ConfigMap();
        for (String key : srcConfig.keySet()) {
            IConfiguration config = srcConfig.getConfigurations().get(key);
            if (config == null) continue;
            this.getConfigurations().put(key, config.clone());
        }
    }

    @Override
    public FreeConfiguration clone() {
        return new FreeConfiguration(this);
    }

    @Override
    public IConfiguration getConfiguration(String key) {
        return this.configMap.get(key);
    }

    @Override
    public IConfiguration putConfiguration(String key, IConfiguration config) {
        return this.configMap.put(key, config);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public IConfiguration getConfiguration() {
        return this;
    }

    @Override
    public boolean configure(IConfiguration config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConfigDescriptor getConfigurationDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, IConfiguration> getConfigurations() {
        return this.configMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigMap
    extends HashMap<String, IConfiguration> {
        private static final long serialVersionUID = 1L;

        protected ConfigMap() {
        }

        protected ConfigMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public IConfiguration put(String key, IConfiguration config) {
            IConfiguration result = super.put(key, config);
            FreeConfiguration.this.put(key, config.getID());
            return result;
        }
    }
}

