/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep;

import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.align.DescMap;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.ImmutableRepSet;
import edu.mit.story.core.rep.RepSerializationProxy;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.character.IAlignedText;
import edu.mit.story.core.util.ImmutableIterator;
import edu.mit.story.core.util.StringUtils;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRep
extends Registered
implements IRep {
    private String fMarkerID;
    private final int minLength;
    private final Version version;
    private final boolean isStructured;
    private final Class<? extends IData> format;
    private int fDepth = -1;
    private Map<IRep.Form, String> fDescNameForms = new HashMap<IRep.Form, String>();
    private IConfigDescriptor cDesc;
    protected IRepSet fAntecedents;

    public AbstractRep(Class<? extends IData> format) {
        this(format, v1);
    }

    public AbstractRep(Class<? extends IData> format, Version version) {
        this(format, version, 0);
    }

    public AbstractRep(Class<? extends IData> format, int minLength) {
        this(format, v1, minLength);
    }

    public AbstractRep(Class<? extends IData> format, Version version, int minLength) {
        super(null, null, null);
        if (format == null) {
            throw new NullPointerException();
        }
        if (minLength < 0) {
            throw new IllegalArgumentException();
        }
        if (version == null) {
            version = v1;
        }
        this.format = format;
        this.version = version;
        this.minLength = minLength;
        this.isStructured = IStructuredData.class.isAssignableFrom(format);
    }

    @Override
    public IConfigDescriptor getConfigurationDescriptor() {
        if (this.cDesc == null) {
            this.cDesc = this.createConfigurationDescriptor(this.getID(), this.getName(), this.getDescription());
        }
        return this.cDesc;
    }

    protected IConfigDescriptor createConfigurationDescriptor(String id, String name, String desc) {
        return null;
    }

    @Override
    public String getDescriptionName(IRep.Form form) {
        return this.fDescNameForms.get((Object)form);
    }

    @Override
    public int getDepth() {
        if (this.fDepth == -1) {
            Iterator<IRep> i = this.anteIterator();
            while (i.hasNext()) {
                this.fDepth = Math.max(this.fDepth, i.next().getDepth());
            }
            this.fDepth = this.fDepth == -1 ? 0 : ++this.fDepth;
        }
        return this.fDepth;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getMarkerID() {
        return this.fMarkerID;
    }

    @Override
    public boolean setMarkerID(String id) {
        if (this.fMarkerID != null || StringUtils.isEmpty(id)) {
            return false;
        }
        this.fMarkerID = id;
        return true;
    }

    @Override
    public boolean setDescriptionName(Map<IRep.Form, String> descriptionNames) {
        if (!this.fDescNameForms.isEmpty() || descriptionNames == null || descriptionNames.isEmpty()) {
            return false;
        }
        this.fDescNameForms.putAll(descriptionNames);
        return true;
    }

    @Override
    public IRepSet getAntecedents() {
        if (this.fAntecedents == null) {
            this.initAntecedents();
        }
        return new RepSet(this.fAntecedents);
    }

    @Override
    public int antecedentCount() {
        if (this.fAntecedents == null) {
            this.initAntecedents();
        }
        return this.fAntecedents.size();
    }

    @Override
    public Iterator<IRep> anteIterator() {
        if (this.fAntecedents == null) {
            this.initAntecedents();
        }
        return new ImmutableIterator<IRep>(this.fAntecedents.iterator());
    }

    protected final void initAntecedents() {
        if (this.fAntecedents != null) {
            return;
        }
        RepSet hidden = new RepSet();
        this.initAntecedentsInternal(hidden);
        this.fAntecedents = new ImmutableRepSet(hidden);
    }

    protected abstract void initAntecedentsInternal(IRepSet var1);

    @Override
    public boolean dependsOn(IRep rep) {
        if (this.fAntecedents == null) {
            this.initAntecedents();
        }
        return this.fAntecedents.contains(rep);
    }

    @Override
    public Class<? extends IData> getDataFormat() {
        return this.format;
    }

    @Override
    public boolean isStructured() {
        return this.isStructured;
    }

    @Override
    public int getMinimumDescriptionLength() {
        return this.minLength;
    }

    @Override
    public int getIndexLength(IStoryData data) {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public int compareTo(IRep that) {
        return RepUtils.compare(this, that);
    }

    @Override
    public boolean isTransferable() {
        return true;
    }

    @Override
    public IDescMap align(IDescSet source, IDescSet target, IAlignedStoryModel model) {
        ArrayList<Aligner.Pair<IDesc, IDesc>> alignment = new ArrayList<Aligner.Pair<IDesc, IDesc>>(source.size());
        IAlignedText alignedText = model.getAlignedText();
        block0: for (IDesc srcDesc : source) {
            int offset = alignedText.getOffset(srcDesc.getOffset());
            int rightOffset = alignedText.getRightOffset(srcDesc.getRightOffset());
            SimplePosition p = new SimplePosition(offset, rightOffset - offset);
            for (IDesc tgtDesc : target.matchSet(p)) {
                if (!srcDesc.equals(tgtDesc, model)) continue;
                alignment.add(new Aligner.Pair<IDesc, IDesc>(srcDesc, tgtDesc));
                continue block0;
            }
        }
        return new DescMap(source, target, alignment);
    }

    @Override
    public void checkType(IHasRep hasRep) {
        if (!this.isType(hasRep)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isType(IHasRep hasRep) {
        return hasRep == null ? false : this.equals(hasRep.getRep());
    }

    @Override
    public IData reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        return this.reconstitute(p, description, model);
    }

    @Override
    public final int getImplementationCode() {
        return 1;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IRepresentation;
    }

    @Override
    public final String getSerializedData() {
        return null;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof IRep)) {
            return false;
        }
        return RepUtils.equal(this, (IRep)obj);
    }

    public final int hashCode() {
        return RepUtils.hashCode(this);
    }

    public final String toString() {
        return RepUtils.toString(this);
    }

    public final Object writeReplace() throws ObjectStreamException {
        return new RepSerializationProxy(this.getID());
    }

    @Override
    public IModelChange getBatchModelChange() {
        return null;
    }
}

