/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.text.ITextRegion;
import edu.mit.story.core.rep.text.TextRegion;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRep
extends AbstractRep {
    private static final long serialVersionUID = 1L;
    private static IRep fInstance = null;
    public static final Pattern whitespace = Pattern.compile("\\s+");
    public static final String space = " ";
    public static final String ellipsis = "...";

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep("edu.mit.story.text");
        }
        return fInstance;
    }

    public TextRep() {
        super(ITextRegion.class, 1);
    }

    @Override
    protected void initAntecedentsInternal(IRepSet container) {
        container.add(CharRep.getInstance());
    }

    @Override
    public String serialize(IData data) {
        ITextRegion region = (ITextRegion)data;
        return region.serialize();
    }

    @Override
    public TextRegion reconstitute(IHasPosition p, String dataStr, IStoryModel provider) {
        return TextRegion.reconstitute(dataStr);
    }

    @Override
    public boolean isTransferable() {
        return false;
    }

    public static String getText(IHasPosition range, IStoryData data) {
        StringBuilder sb = new StringBuilder(range.getLength());
        TextRep.getText(range, data, sb);
        return sb.toString();
    }

    public static void getText(IHasPosition range, IStoryData data, StringBuilder sb) {
        IDescSet textDescs;
        if (data == null | range == null) {
            return;
        }
        ICharStore store = CharRep.extractCharStore(data);
        if (store == null) {
            return;
        }
        if (store.getLength() <= range.getOffset()) {
            return;
        }
        if (store.getLength() < range.getRightOffset()) {
            range = new SimplePosition(range.getOffset(), store.getLength() - range.getOffset());
        }
        if ((textDescs = data.getDescriptions(TextRep.getInstance())).isEmpty()) {
            return;
        }
        textDescs = textDescs.closedSet(range);
        int i = 0;
        while (i < range.getLength()) {
            sb.append(' ');
            ++i;
        }
        for (IDesc desc : textDescs) {
            IHasPosition is;
            if (desc.getData() != TextRegion.TEXT || (is = PositionUtils.intersection(desc, range)) == null) continue;
            String text = store.get(is.getOffset(), is.getLength());
            sb.replace(is.getOffset() - range.getOffset(), is.getRightOffset() - range.getOffset(), text);
        }
    }

    public static String getPrettyText(IHasPosition range, IStoryData provider) {
        String text = TextRep.getText(range, provider);
        Matcher matcher = whitespace.matcher(text);
        return matcher.replaceAll(space);
    }

    public static String getEllipsedText(IHasPosition range, IStoryData provider, int limit) {
        if (limit < 9) {
            throw new IllegalArgumentException();
        }
        String text = TextRep.getPrettyText(range, provider);
        if (text.length() < limit) {
            return text;
        }
        StringBuilder sb = new StringBuilder(limit);
        sb.append(text.substring(0, limit - 6));
        sb.append(ellipsis);
        sb.append(text.substring(text.length() - 3));
        return sb.toString();
    }

    public static String getEllipsedText(IHasPositionSet<? extends IHasPosition> regions, IStoryData provider) {
        StringBuffer sb = new StringBuffer();
        Iterator i = regions.iterator();
        while (i.hasNext()) {
            sb.append(TextRep.getPrettyText((IHasPosition)i.next(), provider));
            if (!i.hasNext()) continue;
            sb.append(ellipsis);
        }
        return sb.toString();
    }
}

