/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasContext;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractMapLabel
implements Label,
HasWord,
HasTag,
HasCategory,
HasContext,
Serializable {
    static final int initCapacity = 5;
    public static final String VALUE_KEY = "value";
    public static final String TAG_KEY = "tag";
    public static final String WORD_KEY = "word";
    public static final String LEMMA_KEY = "lemma";
    public static final String CATEGORY_KEY = "cat";
    public static final String HEAD_WORD_KEY = "hw";
    public static final String HEAD_TAG_KEY = "ht";
    public static final String INDEX_KEY = "idx";
    public static final String ARG_KEY = "arg";
    public static final String MARKING_KEY = "mark";
    public static final String SEMANTIC_HEAD_WORD_KEY = "shw";
    public static final String SEMANTIC_HEAD_POS_KEY = "shp";
    public static final String VERB_SENSE_KEY = "vs";
    public static final String CATEGORY_FUNCTIONAL_TAG_KEY = "cft";
    public static final String NER_KEY = "ner";
    public static final String LEFT_TERM_KEY = "LEFT_TERM";
    public static final String PARENT_KEY = "PARENT";
    public static final String SPAN_KEY = "SPAN";
    public static final String BEFORE_KEY = "before";
    public static final String AFTER_KEY = "after";
    public static final String CURRENT_KEY = "current";
    public static final String ANSWER_KEY = "answer";
    public static final String GOLDANSWER_KEY = "goldAnswer";
    public static final String FEATURES_KEY = "features";
    public static final String INTERPRETATION_KEY = "interpretation";
    public static final String ROLE_KEY = "srl";
    public static final String GAZETTEER_KEY = "gazetteer";
    public static final String STEM_KEY = "stem";
    public static final String POLARITY_KEY = "polarity";
    public static final String CH_CHAR_KEY = "char";
    public static final String CH_ORIG_SEG_KEY = "orig_seg";
    public static final String CH_SEG_KEY = "seg";
    protected Map map;
    protected MapFactory mapFactory;
    private static final long serialVersionUID = -980833749513621054L;

    protected AbstractMapLabel() {
        this(null);
    }

    protected AbstractMapLabel(MapFactory mapFactory) {
        this.mapFactory = mapFactory == null ? MapFactory.HASH_MAP_FACTORY : mapFactory;
        this.map = this.mapFactory.newMap(5);
    }

    public Map map() {
        return this.map;
    }

    public Object get(Object key) {
        Object v = this.map.get(key);
        if (v == null) {
            return "";
        }
        return v;
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public String value() {
        return (String)this.map.get(VALUE_KEY);
    }

    public void setValue(String value) {
        this.map.put(VALUE_KEY, value);
    }

    public void setFromString(String str) {
        this.setValue(str);
    }

    public String category() {
        Object cat = this.map.get(CATEGORY_KEY);
        if (cat != null && cat instanceof String) {
            return (String)cat;
        }
        return null;
    }

    public void setCategory(String category) {
        this.map.put(CATEGORY_KEY, category);
    }

    public String word() {
        return (String)this.map.get(WORD_KEY);
    }

    public void setWord(String word) {
        this.map.put(WORD_KEY, word);
    }

    public IntPair span() {
        return (IntPair)this.map.get(SPAN_KEY);
    }

    public void setSpan(String span) {
        this.map.put(SPAN_KEY, span);
    }

    public Object headWord() {
        return this.map.get(HEAD_WORD_KEY);
    }

    public void setHeadWord(Object headWordPtr) {
        this.map.put(HEAD_WORD_KEY, headWordPtr);
        if (headWordPtr instanceof HasWord) {
            this.setWord(((HasWord)headWordPtr).word());
        } else if (headWordPtr instanceof Label) {
            this.setWord(((Label)headWordPtr).value());
        }
    }

    public String getSemanticWord() {
        Object word = this.map.get(SEMANTIC_HEAD_WORD_KEY);
        return word != null ? word.toString() : null;
    }

    public void setSemanticWord(String hWord) {
        this.map.put(SEMANTIC_HEAD_WORD_KEY, hWord);
    }

    public String getSemanticTag() {
        Object word = this.map.get(SEMANTIC_HEAD_POS_KEY);
        return word != null ? word.toString() : null;
    }

    public void setSemanticTag(String hTag) {
        this.map.put(SEMANTIC_HEAD_POS_KEY, hTag);
    }

    public String tag() {
        Object tag = this.map.get(TAG_KEY);
        if (tag != null && tag instanceof String) {
            return (String)tag;
        }
        return null;
    }

    public void setTag(String tag) {
        this.map.put(TAG_KEY, tag);
    }

    public Object headTag() {
        return this.map.get(HEAD_TAG_KEY);
    }

    public void setHeadTag(Object headTagPtr) {
        this.map.put(HEAD_TAG_KEY, headTagPtr);
        if (headTagPtr instanceof HasTag) {
            this.setTag(((HasTag)headTagPtr).tag());
        } else if (headTagPtr instanceof Label) {
            this.setTag(((Label)headTagPtr).value());
        }
    }

    public String ner() {
        Object ner = this.map.get(NER_KEY);
        return (String)ner;
    }

    public void setNER(String ner) {
        this.map.put(NER_KEY, ner);
    }

    public int index() {
        Object index = this.map.get(INDEX_KEY);
        if (index != null && index instanceof Integer) {
            return (Integer)index;
        }
        return -1;
    }

    public void setIndex(int index) {
        this.map.put(INDEX_KEY, new Integer(index));
    }

    public String before() {
        Object before = this.map.get(BEFORE_KEY);
        if (before == null) {
            before = "";
        }
        return (String)before;
    }

    public void setBefore(String before) {
        this.map.put(BEFORE_KEY, before);
    }

    public void prependBefore(String before) {
        String oldBefore = this.before();
        if (oldBefore == null) {
            oldBefore = "";
        }
        this.setBefore(before + oldBefore);
    }

    public String current() {
        Object current = this.map.get(CURRENT_KEY);
        if (current == null) {
            current = "";
        }
        return (String)current;
    }

    public void setCurrent(String current) {
        this.map.put(CURRENT_KEY, current);
    }

    public String after() {
        Object after = this.map.get(AFTER_KEY);
        if (after == null) {
            after = "";
        }
        return (String)after;
    }

    public void setAfter(String after) {
        this.map.put(AFTER_KEY, after);
    }

    public void appendAfter(String after) {
        String oldAfter = this.after();
        if (oldAfter == null) {
            oldAfter = "";
        }
        this.setAfter(oldAfter + after);
    }

    public String answer() {
        return (String)this.get(ANSWER_KEY);
    }

    public void setAnswer(String answer) {
        this.put(ANSWER_KEY, answer);
    }

    public String goldAnswer() {
        return (String)this.get(GOLDANSWER_KEY);
    }

    public void setGoldAnswer(String goldAnswer) {
        this.put(GOLDANSWER_KEY, goldAnswer);
    }

    public Collection getFeatures() {
        return (Collection)this.map.get(FEATURES_KEY);
    }

    public void setFeatures(Collection features) {
        this.map.put(FEATURES_KEY, features);
    }

    public Object interpretation() {
        return this.map.get(INTERPRETATION_KEY);
    }

    public void setInterpretation(Object interpretation) {
        this.map.put(INTERPRETATION_KEY, interpretation);
    }

    public String getLemma() {
        return (String)this.map.get(LEMMA_KEY);
    }

    public void setLemma(String lemma) {
        this.map.put(LEMMA_KEY, lemma);
    }

    public String getRole() {
        return (String)this.map.get(ROLE_KEY);
    }

    public void setRole(String role) {
        this.map.put(ROLE_KEY, role);
    }
}

