/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class Experiments {
    public static int[][] vArray;
    protected static int number;
    protected int[] px;
    protected int[] py;
    protected int[] maxY;
    protected static int[][] pxy;
    public static int xSize;
    public static int ySize;
    private ArrayList v = new ArrayList();
    static int dim;
    public double[][] values;

    static {
        dim = 5;
    }

    public int getNumber() {
        return number;
    }

    public Experiments() {
    }

    public Experiments(int[][] vArray) {
        Experiments.vArray = vArray;
        number = vArray.length;
        this.ptilde();
    }

    public Experiments(int[][] vArray, int[] maxYs) {
        Experiments.vArray = vArray;
        number = vArray.length;
        this.ptilde();
        this.maxY = maxYs;
    }

    public Experiments(int[][] vArray, int ySize) {
        Experiments.vArray = vArray;
        number = vArray.length;
        Experiments.ySize = ySize;
        this.ptilde(ySize);
    }

    public Index createIndex() {
        Index<IntPair> index = new Index<IntPair>();
        int x = 0;
        while (x < this.px.length) {
            int numberY = this.numY(x);
            int y = 0;
            while (y < numberY) {
                index.add(new IntPair(x, y));
                ++y;
            }
            ++x;
        }
        return index;
    }

    public Experiments(String filename) {
        try {
            Exception e1 = new Exception("Incorrect data file format");
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String head = in.readLine();
            if (!head.equals("<data>")) {
                throw e1;
            }
            String xLine = in.readLine();
            if (!xLine.startsWith("<xSize>")) {
                throw e1;
            }
            if (!xLine.endsWith("</xSize>")) {
                throw e1;
            }
            int index1 = xLine.indexOf(">");
            int index2 = xLine.lastIndexOf("<");
            String xSt = xLine.substring(index1 + 1, index2);
            System.out.println(xSt);
            xSize = new Integer(xSt);
            System.out.println("xSize is " + xSize);
            String yLine = in.readLine();
            if (!yLine.startsWith("<ySize>")) {
                throw e1;
            }
            if (!yLine.endsWith("</ySize>")) {
                throw e1;
            }
            index1 = yLine.indexOf(">");
            index2 = yLine.lastIndexOf("<");
            ySize = new Integer(yLine.substring(index1 + 1, index2));
            System.out.println("ySize is " + ySize);
            String nLine = in.readLine();
            if (!nLine.startsWith("<number>")) {
                throw e1;
            }
            if (!nLine.endsWith("</number>")) {
                throw e1;
            }
            index1 = nLine.indexOf(">");
            index2 = nLine.lastIndexOf("<");
            number = new Integer(nLine.substring(index1 + 1, index2));
            System.out.println("number is " + number);
            vArray = new int[number][2];
            int current = 0;
            while (current < number) {
                String experiment = in.readLine();
                int index = experiment.indexOf(" ");
                int x = new Integer(experiment.substring(0, index));
                int y = new Integer(experiment.substring(index + 1));
                Experiments.vArray[current][0] = x;
                Experiments.vArray[current][1] = y;
                ++current;
            }
            this.ptilde(ySize);
        }
        catch (Exception e) {
            System.out.println("Incorrect data file format");
            e.printStackTrace();
        }
    }

    public void add(Experiments m) {
        this.v.add(m);
    }

    public void ptilde() {
        int maxX = 0;
        int maxY = 0;
        int i = 0;
        i = 0;
        while (i < number) {
            if (maxX < vArray[i][0]) {
                maxX = vArray[i][0];
            }
            if (maxY < vArray[i][1]) {
                maxY = vArray[i][1];
            }
            ++i;
        }
        this.px = new int[maxX + 1];
        this.py = new int[maxY + 1];
        pxy = new int[maxX + 1][dim];
        xSize = maxX + 1;
        ySize = maxY + 1;
        int[] yArr = new int[dim];
        i = 0;
        while (i < number) {
            int xC = vArray[i][0];
            int yC = vArray[i][1];
            int n = xC;
            this.px[n] = this.px[n] + 1;
            int n2 = yC;
            this.py[n2] = this.py[n2] + 1;
            int j = 0;
            while (j < dim) {
                yArr[j] = pxy[xC][j] > 0 ? pxy[xC][j] % ySize : -1;
                ++j;
            }
            j = 0;
            while (j < dim) {
                if (yArr[j] == -1) {
                    Experiments.pxy[xC][j] = ySize + yC;
                    break;
                }
                if (yC == yArr[j]) {
                    int[] nArray = pxy[xC];
                    int n3 = j;
                    nArray[n3] = nArray[n3] + ySize;
                    break;
                }
                ++j;
            }
            ++i;
        }
        int y = 0;
        while (y < ySize) {
            double sum = 0.0;
            int x = 0;
            while (x < xSize) {
                double p1 = this.ptildeXY(x, y);
                sum += p1;
                ++x;
            }
            if (Math.abs(this.ptildeY(y) - sum) > 1.0E-5) {
                System.out.println(" error ");
            }
            ++y;
        }
        this.maxY = new int[xSize];
        int j = 0;
        while (j < xSize) {
            this.maxY[j] = ySize;
            ++j;
        }
    }

    public void setMaxY(int[] maxY) {
        this.maxY = maxY;
    }

    public int numY(int x) {
        return this.maxY[x];
    }

    public void ptilde(int ySize) {
        int maxX = 0;
        int maxY = 0;
        int i = 0;
        Experiments.ySize = ySize;
        i = 0;
        while (i < number) {
            if (maxX < vArray[i][0]) {
                maxX = vArray[i][0];
            }
            if (maxY < vArray[i][1]) {
                maxY = vArray[i][1];
            }
            ++i;
        }
        this.px = new int[maxX + 1];
        maxY = ySize - 1;
        this.py = new int[ySize];
        pxy = new int[maxX + 1][dim];
        xSize = maxX + 1;
        ySize = maxY + 1;
        int[] yArr = new int[dim];
        i = 0;
        while (i < number) {
            int xC = vArray[i][0];
            int yC = vArray[i][1];
            int n = xC;
            this.px[n] = this.px[n] + 1;
            int n2 = yC;
            this.py[n2] = this.py[n2] + 1;
            int j = 0;
            while (j < dim) {
                yArr[j] = pxy[xC][j] > 0 ? pxy[xC][j] % ySize : -1;
                ++j;
            }
            j = 0;
            while (j < dim) {
                if (yArr[j] == -1) {
                    Experiments.pxy[xC][j] = ySize + yC;
                    break;
                }
                if (yC == yArr[j]) {
                    int[] nArray = pxy[xC];
                    int n3 = j;
                    nArray[n3] = nArray[n3] + ySize;
                    break;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("ySize is" + ySize);
        int y = 0;
        while (y < ySize) {
            double sum = 0.0;
            int x = 0;
            while (x < xSize) {
                double p1 = this.ptildeXY(x, y);
                sum += p1;
                ++x;
            }
            if (Math.abs(this.ptildeY(y) - sum) > 1.0E-5) {
                System.out.println(" error ");
            } else {
                System.out.println(" for y " + y + " sum " + sum);
            }
            ++y;
        }
    }

    public double ptildeX(int x) {
        if (x > xSize - 1) {
            return 0.0;
        }
        return (double)this.px[x] / (double)number;
    }

    public double ptildeY(int y) {
        if (y > ySize - 1) {
            return 0.0;
        }
        return (double)this.py[y] / (double)Experiments.size();
    }

    public double ptildeXY(int x, int y) {
        int j = 0;
        while (j < dim) {
            if (y == pxy[x][j] % ySize) {
                return (double)(pxy[x][j] / ySize) / (double)Experiments.size();
            }
            ++j;
        }
        return 0.0;
    }

    public int[] get(int index) {
        return vArray[index];
    }

    public static int size() {
        return number;
    }

    public void print() {
        System.out.println(" Experiments : ");
        int i = 0;
        while (i < Experiments.size()) {
            System.out.println(String.valueOf(vArray[i][0]) + " : " + vArray[i][1]);
            ++i;
        }
        System.out.println(" p(x) ");
        i = 0;
        while (i < xSize) {
            System.out.println(String.valueOf(i) + " : " + this.ptildeX(i));
            ++i;
        }
        System.out.println(" p(y) ");
        i = 0;
        while (i < ySize) {
            System.out.println(String.valueOf(i) + " : " + this.ptildeY(i));
            ++i;
        }
    }

    public void print(PrintFile pf) {
        pf.println(" Experiments : ");
        int i = 0;
        while (i < Experiments.size()) {
            pf.println(String.valueOf(vArray[i][0]) + " : " + vArray[i][1]);
            ++i;
        }
        pf.println(" p(x) ");
        i = 0;
        while (i < xSize) {
            pf.println(String.valueOf(i) + " : " + this.ptildeX(i));
            ++i;
        }
        pf.println(" p(y) ");
        i = 0;
        while (i < ySize) {
            pf.println(String.valueOf(i) + " : " + this.ptildeY(i));
            ++i;
        }
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rF = new OutDataStreamFile(filename);
            rF.writeInt(xSize);
            rF.writeInt(ySize);
            rF.writeInt(number);
            int i = 0;
            while (i < xSize) {
                rF.writeInt(this.px[i]);
                ++i;
            }
            int j = 0;
            while (j < ySize) {
                rF.writeInt(this.py[j]);
                ++j;
            }
            i = 0;
            while (i < xSize) {
                int j2 = 0;
                while (j2 < dim) {
                    rF.writeInt(pxy[i][j2]);
                    ++j2;
                }
                ++i;
            }
            rF.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rF = new InDataStreamFile(filename);
            xSize = rF.readInt();
            ySize = rF.readInt();
            number = rF.readInt();
            this.px = new int[xSize];
            this.py = new int[ySize];
            pxy = new int[xSize][ySize];
            int i = 0;
            while (i < xSize) {
                this.px[i] = rF.readInt();
                ++i;
            }
            int j = 0;
            while (j < ySize) {
                this.py[j] = rF.readInt();
                ++j;
            }
            i = 0;
            while (i < xSize) {
                int j2 = 0;
                while (j2 < dim) {
                    Experiments.pxy[i][j2] = rF.readInt();
                    ++j2;
                }
                ++i;
            }
            rF.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = -1;
        nArray[4] = -2;
        boolean[] blArray = new boolean[5];
        blArray[3] = true;
        blArray[4] = true;
    }
}

