/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnglishTreebankParserParams
extends AbstractTreebankParserParams {
    private HeadFinder headFinder;
    private static String[] sisterSplit1 = new String[]{"ADJP=l=VBD", "ADJP=l=VBP", "NP=r=RBR", "PRN=r=.", "ADVP=l=PP", "PP=l=JJ", "PP=r=NP", "SBAR=l=VB", "PP=l=VBG", "ADJP=r=,", "ADVP=r=.", "ADJP=l=VB", "FRAG=l=FRAG", "FRAG=r=:", "PP=r=,", "ADJP=l=,", "FRAG=r=FRAG", "FRAG=l=:", "PRN=r=VP", "PP=l=RB", "S=l=ADJP", "SBAR=l=VBN", "NP=r=NX", "SBAR=l=VBZ", "SBAR=l=ADVP", "QP=r=JJ", "SBAR=l=PP", "SBAR=l=ADJP", "NP=r=VBG", "VP=r=:", "VP=l=ADJP", "SBAR=l=VBP", "ADVP=r=NP", "PP=l=VB", "VP=r=PP", "ADJP=r=SBAR", "NP=r=JJR", "SBAR=l=NN", "S=l=RB", "S=l=NNS", "S=r=SBAR", "S=l=WHPP", "VP=l=:", "ADVP=l=NP", "ADVP=r=PP", "ADJP=l=JJ", "NP=r=VBN", "NP=l=PRN", "VP=r=S", "NP=r=NNPS", "NX=r=NX", "ADJP=l=PRP$", "SBAR=l=CC", "SBAR=l=S", "S=l=PRT", "ADVP=l=VB", "ADVP=r=JJ", "NP=l=DT"};
    private static String[] sisterSplit2 = new String[]{"S=r=PP", "NP=r=JJS", "ADJP=r=NNP", "NP=l=PRT", "ADJP=r=PP", "ADJP=l=VBZ", "PP=r=VP", "NP=r=CD", "ADVP=l=IN", "ADVP=l=,", "ADJP=r=JJ", "ADVP=l=VBD", "PP=r=.", "S=l=ADVP", "S=l=DT", "PP=l=NP", "VP=l=PRN", "NP=r=IN", "NP=r=``"};
    private static String[] sisterSplit3 = new String[]{"PP=l=VBD", "ADJP=r=NNS", "S=l=:", "NP=l=ADVP", "NP=r=PRN", "NP=r=-RRB-", "NP=l=-LRB-", "NP=l=JJ", "SBAR=r=.", "S=r=:", "ADVP=r=VP", "NP=l=RB", "NP=r=RB", "S=l=VBP", "SBAR=r=,", "VP=r=,", "PP=r=PP", "NP=r=S", "ADJP=l=NP", "VP=l=VBG", "PP=l=PP"};
    private static String[] sisterSplit4 = new String[]{"VP=l=NP", "NP=r=NN", "NP=r=VP", "VP=r=.", "NP=r=PP", "VP=l=TO", "VP=l=MD", "NP=r=,", "NP=r=NP", "NP=r=.", "NP=l=IN", "NP=l=NP", "VP=l=,", "VP=l=S", "NP=l=,", "VP=l=VBZ", "S=r=.", "NP=r=NNS", "S=l=IN", "NP=r=JJ", "NP=r=NNP", "VP=l=VBD", "S=l=WHNP", "VP=r=NP", "VP=l=''", "VP=l=VBP", "NP=l=:", "S=r=,", "VP=l=``", "VP=l=VB", "NP=l=S", "NP=l=VP", "NP=l=VB", "NP=l=VBD", "NP=r=SBAR", "NP=r=:", "VP=l=PP", "NP=l=VBZ", "NP=l=CC", "NP=l=''", "S=r=NP", "S=r=S", "S=l=VBN", "NP=l=``", "ADJP=r=NN", "S=r=VP", "NP=r=CC", "VP=l=RB", "S=l=S", "S=l=NP", "NP=l=TO", "S=l=,", "S=l=VBD", "S=r=''", "S=l=``", "S=r=CC", "PP=l=,", "S=l=CC", "VP=l=CC", "ADJP=l=DT", "NP=l=VBG", "VP=r=''", "SBAR=l=NP", "VP=l=VP", "NP=l=PP", "S=l=VB", "SBAR=l=VBD", "VP=l=ADVP", "VP=l=VBN", "NP=r=''", "VP=l=SBAR", "SBAR=l=,", "S=l=WHADVP", "VP=r=VP", "NP=r=ADVP", "QP=r=NNS", "NP=l=VBP", "S=l=VBZ", "NP=l=VBN", "S=l=PP", "VP=r=CC", "NP=l=SBAR", "SBAR=r=NP", "S=l=VBG", "SBAR=r=VP", "NP=r=ADJP", "S=l=JJ", "S=l=NN", "QP=r=NN"};
    private static TreeFactory categoryWordTagTreeFactory = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
    private static final long serialVersionUID = 4153878351331522581L;

    public EnglishTreebankParserParams() {
        super(new PennTreebankLanguagePack());
        this.headFinder = new ModCollinsHeadFinder(this.tlp);
        this.inputEncoding = this.tlp.getEncoding();
        this.outputEncoding = this.tlp.getEncoding();
    }

    public HeadFinder headFinder() {
        return this.headFinder;
    }

    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory());
    }

    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory());
    }

    public TreeReaderFactory treeReaderFactory() {
        return new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new NPTmpRetainingTreeNormalizer(EnglishTrain.splitTMP, EnglishTrain.splitSGapped == 5, Train.leaveItAll, EnglishTrain.splitNPADV >= 1, EnglishTreebankParserParams.this.headFinder()));
            }
        };
    }

    public MemoryTreebank testMemoryTreebank() {
        return new MemoryTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new BobChrisTreeNormalizer(EnglishTreebankParserParams.this.tlp));
            }
        });
    }

    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp, true, EnglishTrain.splitBaseNP == 2);
    }

    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.tlp, true, EnglishTrain.splitBaseNP == 2);
    }

    public TreebankLanguagePack treebankLanguagePack() {
        return this.tlp;
    }

    public PrintWriter pw(OutputStream o) {
        return new PrintWriter(o, true);
    }

    public String[] sisterSplitters() {
        switch (EnglishTrain.sisterSplitLevel) {
            case 1: {
                return sisterSplit1;
            }
            case 2: {
                return sisterSplit2;
            }
            case 3: {
                return sisterSplit3;
            }
            case 4: {
                return sisterSplit4;
            }
        }
        return new String[0];
    }

    public TreeTransformer subcategoryStripper() {
        return new EnglishSubcategoryStripper();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tree transformTree(Tree t, Tree root) {
        String cat;
        String tag;
        String word;
        block373: {
            Tree[] kids;
            String baseCat;
            String parentStr;
            block375: {
                String cat2;
                int i;
                int seenS;
                boolean sawSBeforePredCat;
                boolean seenPredCat;
                int seenNP;
                block380: {
                    boolean seenS2;
                    boolean seenCC;
                    boolean seenPredCat2;
                    block379: {
                        int seenNP2;
                        boolean seenPredCat3;
                        block377: {
                            block378: {
                                block376: {
                                    block374: {
                                        String baseTag;
                                        String baseParentStr;
                                        block361: {
                                            boolean split;
                                            block364: {
                                                Tree parent;
                                                block372: {
                                                    boolean annotateHave;
                                                    Tree[] sisters;
                                                    block370: {
                                                        block368: {
                                                            block371: {
                                                                block369: {
                                                                    int i2;
                                                                    block365: {
                                                                        block367: {
                                                                            block366: {
                                                                                char ch;
                                                                                boolean foundJJ;
                                                                                Tree[] kids2;
                                                                                block356: {
                                                                                    block357: {
                                                                                        block363: {
                                                                                            block362: {
                                                                                                block220: {
                                                                                                    block359: {
                                                                                                        block360: {
                                                                                                            block358: {
                                                                                                                String baseGrandParentStr;
                                                                                                                block221: {
                                                                                                                    block344: {
                                                                                                                        block355: {
                                                                                                                            block354: {
                                                                                                                                String grandParentStr;
                                                                                                                                block353: {
                                                                                                                                    block349: {
                                                                                                                                        block352: {
                                                                                                                                            block351: {
                                                                                                                                                block350: {
                                                                                                                                                    block346: {
                                                                                                                                                        block348: {
                                                                                                                                                            block347: {
                                                                                                                                                                block345: {
                                                                                                                                                                    block343: {
                                                                                                                                                                        block222: {
                                                                                                                                                                            block226: {
                                                                                                                                                                                block342: {
                                                                                                                                                                                    block341: {
                                                                                                                                                                                        block340: {
                                                                                                                                                                                            block339: {
                                                                                                                                                                                                block338: {
                                                                                                                                                                                                    block337: {
                                                                                                                                                                                                        block336: {
                                                                                                                                                                                                            block335: {
                                                                                                                                                                                                                block333: {
                                                                                                                                                                                                                    block334: {
                                                                                                                                                                                                                        block331: {
                                                                                                                                                                                                                            block332: {
                                                                                                                                                                                                                                block326: {
                                                                                                                                                                                                                                    block330: {
                                                                                                                                                                                                                                        block329: {
                                                                                                                                                                                                                                            block328: {
                                                                                                                                                                                                                                                block327: {
                                                                                                                                                                                                                                                    block325: {
                                                                                                                                                                                                                                                        block245: {
                                                                                                                                                                                                                                                            block324: {
                                                                                                                                                                                                                                                                block323: {
                                                                                                                                                                                                                                                                    block322: {
                                                                                                                                                                                                                                                                        block321: {
                                                                                                                                                                                                                                                                            block299: {
                                                                                                                                                                                                                                                                                block320: {
                                                                                                                                                                                                                                                                                    block319: {
                                                                                                                                                                                                                                                                                        block318: {
                                                                                                                                                                                                                                                                                            block317: {
                                                                                                                                                                                                                                                                                                block316: {
                                                                                                                                                                                                                                                                                                    block315: {
                                                                                                                                                                                                                                                                                                        block314: {
                                                                                                                                                                                                                                                                                                            block313: {
                                                                                                                                                                                                                                                                                                                block312: {
                                                                                                                                                                                                                                                                                                                    block311: {
                                                                                                                                                                                                                                                                                                                        block310: {
                                                                                                                                                                                                                                                                                                                            block309: {
                                                                                                                                                                                                                                                                                                                                block308: {
                                                                                                                                                                                                                                                                                                                                    block307: {
                                                                                                                                                                                                                                                                                                                                        block306: {
                                                                                                                                                                                                                                                                                                                                            block305: {
                                                                                                                                                                                                                                                                                                                                                block304: {
                                                                                                                                                                                                                                                                                                                                                    block303: {
                                                                                                                                                                                                                                                                                                                                                        block302: {
                                                                                                                                                                                                                                                                                                                                                            block301: {
                                                                                                                                                                                                                                                                                                                                                                block300: {
                                                                                                                                                                                                                                                                                                                                                                    block250: {
                                                                                                                                                                                                                                                                                                                                                                        block298: {
                                                                                                                                                                                                                                                                                                                                                                            block297: {
                                                                                                                                                                                                                                                                                                                                                                                block296: {
                                                                                                                                                                                                                                                                                                                                                                                    block295: {
                                                                                                                                                                                                                                                                                                                                                                                        block294: {
                                                                                                                                                                                                                                                                                                                                                                                            block293: {
                                                                                                                                                                                                                                                                                                                                                                                                block292: {
                                                                                                                                                                                                                                                                                                                                                                                                    block291: {
                                                                                                                                                                                                                                                                                                                                                                                                        block290: {
                                                                                                                                                                                                                                                                                                                                                                                                            block289: {
                                                                                                                                                                                                                                                                                                                                                                                                                block288: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block287: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block286: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block285: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block284: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block283: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block282: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block281: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block280: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block279: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block278: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block277: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block276: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block275: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block274: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block273: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block272: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block271: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block270: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block269: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block268: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block267: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block266: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block265: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block264: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block263: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block262: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block261: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block260: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block259: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block258: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block257: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block256: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block255: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block254: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block253: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block252: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block251: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block247: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block249: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block248: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block246: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block243: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block244: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block242: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block241: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block240: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block223: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block239: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block238: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block237: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block236: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block235: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block234: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block233: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block232: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block231: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block229: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block230: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block228: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block227: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block224: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block225: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Tree grandParent;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (t == null) return t;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (t.isLeaf()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return t;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (root == null || t.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parent = null;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parent = t.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parentStr = parent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (parent == null || parent.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParent = null;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParent = parent.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParentStr = grandParent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseParentStr = this.tlp.basicCategory(parentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseGrandParentStr = this.tlp.basicCategory(grandParentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CategoryWordTag lab = (CategoryWordTag)t.label();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            word = lab.word();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            tag = lab.tag();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseTag = this.tlp.basicCategory(tag);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = lab.value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!t.isPreTerminal()) break block221;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EnglishTrain.correctTags) break block222;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("NP")) break block223;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("IN")) break block224;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equalsIgnoreCase("a") && !word.equalsIgnoreCase("that")) break block225;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("so") || word.equalsIgnoreCase("about")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("fiscal") || word.equalsIgnoreCase("next")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("RB")) break block227;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("McNally")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (word.equals("multifamily")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("RP")) break block228;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("Howard")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("whole")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("JJ")) break block229;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("U.S.")) break block230;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("ours")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "PRP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("mine")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("NN")) break block231;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("Chapman")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals(":")) break block232;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("'")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "''");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("NNS")) break block233;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("start-up") || word.equals("ground-handling") || word.equals("word-processing") || word.equals("T-shirt") || word.equals("co-pilot")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (word.equals("Sens.") || word.equals("Aichi")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals(":")) break block234;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("'")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "''");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("VBZ")) break block235;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("'s")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "POS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (!word.equals("kills")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("VBG")) break block236;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("preferred")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("VB")) break block237;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("The")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NNP")) break block238;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("Officials")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("Currently")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Orkem")) break block239;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("PRP")) break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("her") && parent.numChildren() > 1) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "PRP$");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("US")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("WHNP")) break block240;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (baseCat.equals("VBP") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "WDT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("UCP")) break block241;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("multifamily")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("PRT")) break block242;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (baseCat.equals("RBR") && word.equals("in")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseParentStr.equals("PP")) break block243;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (parentStr.equals("PP-TMP") && baseCat.equals("RP")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("in") || !baseCat.equals("RP") && !baseCat.equals("NN")) break block244;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (baseCat.equals("RB")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("for") || word.equals("After")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (word.equals("if") && baseCat.equals("JJ")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("VP")) break block245;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NNS")) break block246;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("IN")) break block247;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("complicated")) break block248;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("post")) break block249;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("like")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (word.equals("off")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NN")) break block250;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.endsWith("ing")) break block251;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("bid")) break block252;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("are")) break block253;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("lure")) break block254;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("cost")) break block255;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("agreed")) break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("restructure")) break block257;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("rule")) break block258;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("fret")) break block259;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("retort")) break block260;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("draft")) break block261;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("will")) break block262;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "MD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("yield")) break block263;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("lure")) break block264;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("feel")) break block265;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("institutes")) break block266;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("share")) break block267;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("trade")) break block268;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("beat")) break block269;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("effect")) break block270;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("speed")) break block271;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("work")) break block272;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("act")) break block273;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("drop")) break block274;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("stand")) break block275;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("push")) break block276;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("service")) break block277;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("set")) break block278;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("appeal")) break block279;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("mold")) break block280;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("mean")) break block281;
                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("reconfirm")) break block282;
                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("land")) break block283;
                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("point")) break block284;
                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("rise")) break block285;
                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("pressured")) break block286;
                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("smell")) break block287;
                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("pay")) break block288;
                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("hum")) break block289;
                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("shape")) break block290;
                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("benefit")) break block291;
                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("abducted")) break block292;
                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("look")) break block293;
                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("fare")) break block294;
                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("change")) break block295;
                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("farm")) break block296;
                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("increase")) break block297;
                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("stem")) break block298;
                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("rebounded")) {
                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("face")) {
                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("NNP")) break block299;
                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("GRAB")) break block300;
                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("mature")) break block301;
                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("Face")) break block302;
                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("are")) break block303;
                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Urging")) break block304;
                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (!word.equals("Finding")) break block305;
                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (!word.equals("say")) break block306;
                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (!word.equals("Added")) break block307;
                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Adds")) break block308;
                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (!word.equals("BRACED")) break block309;
                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (!word.equals("REQUIRED")) break block310;
                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (!word.equals("SIZING")) break block311;
                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (!word.equals("REVIEW")) break block312;
                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (!word.equals("code-named")) break block313;
                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (!word.equals("Printed")) break block314;
                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (!word.equals("Rated")) break block315;
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (!word.equals("FALTERS")) break block316;
                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (!word.equals("Got")) break block317;
                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (!word.equals("JUMPING")) break block318;
                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (!word.equals("Branching")) break block319;
                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (!word.equals("Excluding")) break block320;
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (word.equals("Adds")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                                } else if (word.equals("OKing")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (!baseCat.equals("POS")) break block321;
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (!baseCat.equals("VBD")) break block322;
                                                                                                                                                                                                                                                                        if (word.equals("heaves")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (!baseCat.equals("VB")) break block323;
                                                                                                                                                                                                                                                                    if (word.equals("allowed") || word.equals("increased")) {
                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (!baseCat.equals("VBN")) break block324;
                                                                                                                                                                                                                                                                if (word.equals("has")) {
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                                } else if (word.equals("grew") || word.equals("fell")) {
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("being")) {
                                                                                                                                                                                                                                                                if (!cat.equals("VBG")) {
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                                            } else if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (!baseParentStr.equals("S")) break block325;
                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (!baseParentStr.equals("ADJP")) break block326;
                                                                                                                                                                                                                                                    if (!baseCat.equals("UH")) break block327;
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (!baseCat.equals("JJ")) break block328;
                                                                                                                                                                                                                                                if (word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (!baseCat.equals("RB")) break block226;
                                                                                                                                                                                                                                            if (!word.equalsIgnoreCase("free")) break block329;
                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (!word.equalsIgnoreCase("clear")) break block330;
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (word.equalsIgnoreCase("tight")) {
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                                    } else if (word.equalsIgnoreCase("sure")) {
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (!baseParentStr.equals("QP")) break block331;
                                                                                                                                                                                                                                if (!word.equalsIgnoreCase("about")) break block332;
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (!baseCat.equals("JJ")) break block226;
                                                                                                                                                                                                                            if (word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                                            } else if (word.equalsIgnoreCase("as")) {
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!baseParentStr.equals("ADVP")) break block333;
                                                                                                                                                                                                                        if (!baseCat.equals("EX")) break block334;
                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (baseCat.equals("NN") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                                    } else if (baseCat.equals("NNP") && (word.endsWith("ly") || word.equals("Overall"))) {
                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!baseParentStr.equals("SBAR")) break block335;
                                                                                                                                                                                                                if ((word.equalsIgnoreCase("that") || word.equalsIgnoreCase("because") || word.equalsIgnoreCase("while")) && !baseCat.equals("IN")) {
                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                                } else if ((word.equals("Though") || word.equals("Whether")) && baseCat.equals("NNP")) {
                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                }
                                                                                                                                                                                                                break block226;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!baseParentStr.equals("SBARQ")) break block336;
                                                                                                                                                                                                            if (baseCat.equals("S") && word.equalsIgnoreCase("had")) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "SQ");
                                                                                                                                                                                                            }
                                                                                                                                                                                                            break block226;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (!baseCat.equals("JJS")) break block337;
                                                                                                                                                                                                        if (word.equalsIgnoreCase("less")) {
                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                        }
                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (!baseCat.equals("JJ")) break block338;
                                                                                                                                                                                                    if (word.equalsIgnoreCase("%")) {
                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                        break block226;
                                                                                                                                                                                                    } else if (word.equalsIgnoreCase("to")) {
                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "TO");
                                                                                                                                                                                                    }
                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!baseCat.equals(",")) break block339;
                                                                                                                                                                                                if (word.equals("2")) {
                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "CD");
                                                                                                                                                                                                    break block226;
                                                                                                                                                                                                } else if (word.equals("Wa")) {
                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                }
                                                                                                                                                                                                break block226;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (!baseCat.equals("RB")) break block340;
                                                                                                                                                                                            if (word.equals("for")) {
                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                            }
                                                                                                                                                                                            break block226;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (!baseCat.equals("RP")) break block341;
                                                                                                                                                                                        if (word.equals("for")) {
                                                                                                                                                                                            cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                        }
                                                                                                                                                                                        break block226;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!baseCat.equals("NN")) break block342;
                                                                                                                                                                                    if (word.length() == 2 && word.charAt(1) == '.' && Character.isUpperCase(word.charAt(0))) {
                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                        break block226;
                                                                                                                                                                                    } else if (word.equals("Lorillard")) {
                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                    }
                                                                                                                                                                                    break block226;
                                                                                                                                                                                }
                                                                                                                                                                                if (word.equals("for")) {
                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                } else if (word.equalsIgnoreCase("and") && !baseCat.equals("CC")) {
                                                                                                                                                                                    cat = this.changeBaseCat(cat, "CC");
                                                                                                                                                                                } else if (word.equals("ago") && !baseCat.equals("RB")) {
                                                                                                                                                                                    cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                        }
                                                                                                                                                                        if (EnglishTrain.makePPTOintoIN && baseCat.equals("TO") && baseParentStr.equals("PP")) {
                                                                                                                                                                            cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                        }
                                                                                                                                                                        if (EnglishTrain.splitIN == 5 && baseCat.equals("TO") && grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) {
                                                                                                                                                                            cat = this.changeBaseCat(cat, "IN") + "-N";
                                                                                                                                                                        }
                                                                                                                                                                        if (EnglishTrain.splitIN != 1 || !baseCat.equals("IN") || parentStr.charAt(0) != 'S') break block343;
                                                                                                                                                                        cat = cat + "^S";
                                                                                                                                                                        break block344;
                                                                                                                                                                    }
                                                                                                                                                                    if (EnglishTrain.splitIN != 2 || !baseCat.equals("IN")) break block345;
                                                                                                                                                                    if (parentStr.charAt(0) == 'S') {
                                                                                                                                                                        cat = cat + "^S";
                                                                                                                                                                        break block344;
                                                                                                                                                                    } else if (grandParentStr.charAt(0) == 'N') {
                                                                                                                                                                        cat = cat + "^N";
                                                                                                                                                                    }
                                                                                                                                                                    break block344;
                                                                                                                                                                }
                                                                                                                                                                if (EnglishTrain.splitIN != 3 || !baseCat.equals("IN")) break block346;
                                                                                                                                                                if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block347;
                                                                                                                                                                cat = cat + "-N";
                                                                                                                                                                break block344;
                                                                                                                                                            }
                                                                                                                                                            if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block348;
                                                                                                                                                            cat = cat + "-Q";
                                                                                                                                                            break block344;
                                                                                                                                                        }
                                                                                                                                                        if (grandParentStr.equals("S")) {
                                                                                                                                                            cat = baseParentStr.equals("SBAR") ? cat + "-SCC" : cat + "-SC";
                                                                                                                                                            break block344;
                                                                                                                                                        } else if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP")) {
                                                                                                                                                            cat = cat + "-T";
                                                                                                                                                        }
                                                                                                                                                        break block344;
                                                                                                                                                    }
                                                                                                                                                    if (EnglishTrain.splitIN < 4 || EnglishTrain.splitIN > 5 || !baseCat.equals("IN")) break block349;
                                                                                                                                                    if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block350;
                                                                                                                                                    cat = cat + "-N";
                                                                                                                                                    break block344;
                                                                                                                                                }
                                                                                                                                                if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block351;
                                                                                                                                                cat = cat + "-Q";
                                                                                                                                                break block344;
                                                                                                                                            }
                                                                                                                                            if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block352;
                                                                                                                                            if (baseParentStr.equals("SBAR")) {
                                                                                                                                                cat = cat + "-SCC";
                                                                                                                                                break block344;
                                                                                                                                            } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                                cat = cat + "-SC";
                                                                                                                                            }
                                                                                                                                            break block344;
                                                                                                                                        }
                                                                                                                                        if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                                            cat = cat + "-T";
                                                                                                                                        }
                                                                                                                                        break block344;
                                                                                                                                    }
                                                                                                                                    if (EnglishTrain.splitIN != 6 || !baseCat.equals("IN")) break block344;
                                                                                                                                    if (grandParentStr.charAt(0) != 'V' && grandParentStr.charAt(0) != 'A') break block353;
                                                                                                                                    cat = cat + "-V";
                                                                                                                                    break block344;
                                                                                                                                }
                                                                                                                                if (grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) break block344;
                                                                                                                                if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block354;
                                                                                                                                cat = cat + "-Q";
                                                                                                                                break block344;
                                                                                                                            }
                                                                                                                            if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block355;
                                                                                                                            if (baseParentStr.equals("SBAR")) {
                                                                                                                                cat = cat + "-SCC";
                                                                                                                                break block344;
                                                                                                                            } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                cat = cat + "-SC";
                                                                                                                            }
                                                                                                                            break block344;
                                                                                                                        }
                                                                                                                        if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                            cat = cat + "-T";
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (EnglishTrain.splitPercent && word.equals("%")) {
                                                                                                                        cat = cat + "-%";
                                                                                                                    }
                                                                                                                    if (EnglishTrain.splitNNPposition && baseCat.equals("NNP")) {
                                                                                                                        cat = parent.numChildren() == 1 ? cat + "-S" : (parent.firstChild().equals(t) ? cat + "-L" : (parent.lastChild().equals(t) ? cat + "-R" : cat + "-I"));
                                                                                                                    }
                                                                                                                    if (EnglishTrain.splitQuotes && (word.equals("'") || word.equals("`"))) {
                                                                                                                        cat = cat + "-SG";
                                                                                                                    }
                                                                                                                    if (EnglishTrain.splitSFP && baseTag.equals(".")) {
                                                                                                                        if (word.equals("?")) {
                                                                                                                            cat = cat + "-QUES";
                                                                                                                        } else if (word.equals("!")) {
                                                                                                                            cat = cat + "-EXCL";
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (EnglishTrain.tagRBGPA && baseCat.equals("RB")) {
                                                                                                                        cat = cat + "^" + baseGrandParentStr;
                                                                                                                    }
                                                                                                                    if (EnglishTrain.joinPound && baseCat.equals("#")) {
                                                                                                                        cat = this.changeBaseCat(cat, "$");
                                                                                                                    }
                                                                                                                    if (EnglishTrain.joinNounTags) {
                                                                                                                        if (baseCat.equals("NNP")) {
                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                        } else if (baseCat.equals("NNPS")) {
                                                                                                                            cat = this.changeBaseCat(cat, "NNS");
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (EnglishTrain.joinJJ && cat.startsWith("JJ")) {
                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                    }
                                                                                                                    if (EnglishTrain.splitPPJJ && cat.startsWith("JJ") && parentStr.startsWith("PP")) {
                                                                                                                        cat = cat + "^S";
                                                                                                                    }
                                                                                                                    if (!EnglishTrain.splitTRJJ || !cat.startsWith("JJ") || !parentStr.startsWith("PP") && !parentStr.startsWith("ADJP") || this.headFinder().determineHead(parent) != t) break block356;
                                                                                                                    kids2 = parent.children();
                                                                                                                    foundJJ = false;
                                                                                                                    for (i2 = 0; i2 < kids2.length && !foundJJ; ++i2) {
                                                                                                                        if (!kids2[i2].label().value().startsWith("JJ")) continue;
                                                                                                                        foundJJ = true;
                                                                                                                    }
                                                                                                                    break block357;
                                                                                                                }
                                                                                                                kids = t.children();
                                                                                                                if (!baseCat.equals("VP")) break block220;
                                                                                                                if (EnglishTrain.gpaRootVP && this.tlp.isStartSymbol(baseGrandParentStr)) {
                                                                                                                    cat = cat + "~ROOT";
                                                                                                                }
                                                                                                                if (!EnglishTrain.splitVPNPAgr) break block358;
                                                                                                                if (baseTag.equals("VBD") || baseTag.equals("MD")) {
                                                                                                                    cat = cat + "-VBF";
                                                                                                                    break block220;
                                                                                                                } else if (baseTag.equals("VBZ") || baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBP") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                                                                                                                    cat = cat + "-" + baseTag;
                                                                                                                    break block220;
                                                                                                                } else {
                                                                                                                    System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                                                                                }
                                                                                                                break block220;
                                                                                                            }
                                                                                                            if (EnglishTrain.splitVP != 3 && EnglishTrain.splitVP != 4) break block359;
                                                                                                            if (!baseTag.equals("VBZ") && !baseTag.equals("VBD") && !baseTag.equals("VBP") && !baseTag.equals("MD")) break block360;
                                                                                                            cat = cat + "-VBF";
                                                                                                            break block220;
                                                                                                        }
                                                                                                        if (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                                                                                                            cat = cat + "-" + baseTag;
                                                                                                            break block220;
                                                                                                        } else if (EnglishTrain.splitVP == 4) {
                                                                                                            String dTag = EnglishTreebankParserParams.deduceTag(word);
                                                                                                            cat = cat + "-" + dTag;
                                                                                                        }
                                                                                                        break block220;
                                                                                                    }
                                                                                                    if (EnglishTrain.splitVP == 2) {
                                                                                                        cat = baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD") ? cat + "-VBF" : cat + "-" + baseTag;
                                                                                                    } else if (EnglishTrain.splitVP == 1) {
                                                                                                        cat = cat + "-" + baseTag;
                                                                                                    }
                                                                                                }
                                                                                                if (EnglishTrain.dominatesV == 2) {
                                                                                                    if (EnglishTreebankParserParams.hasClausalV(t)) {
                                                                                                        cat = cat + "-v";
                                                                                                    }
                                                                                                } else if (EnglishTrain.dominatesV > 0 && EnglishTreebankParserParams.hasV(t.preTerminalYield())) {
                                                                                                    cat = cat + "-v";
                                                                                                }
                                                                                                if (EnglishTrain.dominatesI && EnglishTreebankParserParams.hasI(t.preTerminalYield())) {
                                                                                                    cat = cat + "-i";
                                                                                                }
                                                                                                if (EnglishTrain.dominatesC && EnglishTreebankParserParams.hasC(t.preTerminalYield())) {
                                                                                                    cat = cat + "-c";
                                                                                                }
                                                                                                if (EnglishTrain.splitNPpercent > 0 && word.equals("%") && (baseCat.equals("NP") || EnglishTrain.splitNPpercent > 1 && baseCat.equals("ADJP") || EnglishTrain.splitNPpercent > 2 && baseCat.equals("QP") || EnglishTrain.splitNPpercent > 3)) {
                                                                                                    cat = cat + "-%";
                                                                                                }
                                                                                                if (EnglishTrain.splitNPPRP && baseTag.equals("PRP")) {
                                                                                                    cat = cat + "-PRON";
                                                                                                }
                                                                                                if (EnglishTrain.splitSbar > 0 && baseCat.equals("SBAR")) {
                                                                                                    boolean foundIn = false;
                                                                                                    boolean foundOrder = false;
                                                                                                    boolean infinitive = baseTag.equals("TO");
                                                                                                    for (int i3 = 0; i3 < kids.length; ++i3) {
                                                                                                        if (kids[i3].isPreTerminal() && kids[i3].children()[0].value().equalsIgnoreCase("in")) {
                                                                                                            foundIn = true;
                                                                                                        }
                                                                                                        if (!kids[i3].isPreTerminal() || !kids[i3].children()[0].value().equalsIgnoreCase("order")) continue;
                                                                                                        foundOrder = true;
                                                                                                    }
                                                                                                    if (EnglishTrain.splitSbar > 1 && infinitive) {
                                                                                                        cat = cat + "-INF";
                                                                                                    }
                                                                                                    if ((EnglishTrain.splitSbar == 1 || EnglishTrain.splitSbar == 3) && foundIn && foundOrder) {
                                                                                                        cat = cat + "-PURP";
                                                                                                    }
                                                                                                }
                                                                                                if (EnglishTrain.splitNPNNP <= 0) break block361;
                                                                                                if (EnglishTrain.splitNPNNP != 1 || !baseCat.equals("NP") || !baseTag.equals("NNP")) break block362;
                                                                                                cat = cat + "-NNP";
                                                                                                break block361;
                                                                                            }
                                                                                            if (EnglishTrain.splitNPNNP != 2 || !baseCat.equals("NP") || !baseTag.startsWith("NNP")) break block363;
                                                                                            cat = cat + "-NNP";
                                                                                            break block361;
                                                                                        }
                                                                                        if (EnglishTrain.splitNPNNP != 3 || !baseCat.equals("NP")) break block361;
                                                                                        split = false;
                                                                                        break block364;
                                                                                    }
                                                                                    for (int j = i2; j < kids2.length; ++j) {
                                                                                        if (!kids2[j].label().value().startsWith("NP")) continue;
                                                                                        cat = cat + "^T";
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                if (EnglishTrain.splitJJCOMP && cat.startsWith("JJ") && (parentStr.startsWith("PP") || parentStr.startsWith("ADJP")) && this.headFinder().determineHead(parent) == t) {
                                                                                    kids2 = parent.children();
                                                                                    foundJJ = false;
                                                                                    for (i2 = 0; i2 < kids2.length && !foundJJ && !kids2[i2].label().value().startsWith("JJ"); ++i2) {
                                                                                    }
                                                                                    if (i2 < kids2.length - 1) {
                                                                                        cat = cat + "^CMPL";
                                                                                    }
                                                                                }
                                                                                if (EnglishTrain.splitMoreLess && ((ch = cat.charAt(0)) == 'R' || ch == 'J' || ch == 'C') && (word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("less") || word.equalsIgnoreCase("least"))) {
                                                                                    cat = cat + "-ML";
                                                                                }
                                                                                if (EnglishTrain.unaryDT && cat.startsWith("DT") && parent.children().length == 1) {
                                                                                    cat = cat + "^U";
                                                                                }
                                                                                if (EnglishTrain.unaryRB && cat.startsWith("RB") && parent.children().length == 1) {
                                                                                    cat = cat + "^U";
                                                                                }
                                                                                if (EnglishTrain.markReflexivePRP && cat.startsWith("PRP") && (word.equalsIgnoreCase("itself") || word.equalsIgnoreCase("themselves") || word.equalsIgnoreCase("himself") || word.equalsIgnoreCase("herself") || word.equalsIgnoreCase("ourselves") || word.equalsIgnoreCase("yourself") || word.equalsIgnoreCase("yourselves") || word.equalsIgnoreCase("myself") || word.equalsIgnoreCase("thyself"))) {
                                                                                    cat = cat + "-SE";
                                                                                }
                                                                                if (EnglishTrain.unaryPRP && cat.startsWith("PRP") && parent.children().length == 1) {
                                                                                    cat = cat + "^U";
                                                                                }
                                                                                if (EnglishTrain.unaryIN && cat.startsWith("IN") && parent.children().length == 1) {
                                                                                    cat = cat + "^U";
                                                                                }
                                                                                if (EnglishTrain.splitCC <= 0 || !baseCat.equals("CC")) break block365;
                                                                                if (EnglishTrain.splitCC != 1 || !word.equals("and") && !word.equals("or")) break block366;
                                                                                cat = cat + "-C";
                                                                                break block365;
                                                                            }
                                                                            if (EnglishTrain.splitCC != 2) break block367;
                                                                            if (word.equalsIgnoreCase("but")) {
                                                                                cat = cat + "-B";
                                                                                break block365;
                                                                            } else if (word.equals("&")) {
                                                                                cat = cat + "-A";
                                                                            }
                                                                            break block365;
                                                                        }
                                                                        if (EnglishTrain.splitCC == 3 && word.equalsIgnoreCase("and")) {
                                                                            cat = cat + "-A";
                                                                        }
                                                                    }
                                                                    if (EnglishTrain.splitNOT && baseCat.equals("RB") && (word.equalsIgnoreCase("n't") || word.equalsIgnoreCase("not") || word.equalsIgnoreCase("nt"))) {
                                                                        cat = cat + "-N";
                                                                    } else if (EnglishTrain.splitRB && baseCat.equals("RB") && (baseParentStr.equals("NP") || baseParentStr.equals("QP") || baseParentStr.equals("ADJP"))) {
                                                                        cat = cat + "^M";
                                                                    }
                                                                    if (EnglishTrain.splitAux <= 1 || !baseCat.equals("VBZ") && !baseCat.equals("VBP") && !baseCat.equals("VBD") && !baseCat.equals("VBN") && !baseCat.equals("VBG") && !baseCat.equals("VB")) break block368;
                                                                    if (!word.equalsIgnoreCase("'s")) break block369;
                                                                    sisters = parent.children();
                                                                    boolean foundMe = false;
                                                                    for (i2 = 0; i2 < sisters.length && !foundMe; ++i2) {
                                                                        if (!sisters[i2].label().value().startsWith("VBZ")) continue;
                                                                        foundMe = true;
                                                                    }
                                                                    annotateHave = false;
                                                                    break block370;
                                                                }
                                                                if (!word.equalsIgnoreCase("is") && !word.equalsIgnoreCase("am") && !word.equalsIgnoreCase("are") && !word.equalsIgnoreCase("was") && !word.equalsIgnoreCase("were") && !word.equalsIgnoreCase("'m") && !word.equalsIgnoreCase("'re") && !word.equalsIgnoreCase("s") && !word.equalsIgnoreCase("being") && !word.equalsIgnoreCase("be") && !word.equalsIgnoreCase("been")) break block371;
                                                                cat = cat + "-BE";
                                                                break block372;
                                                            }
                                                            if (word.equalsIgnoreCase("have") || word.equalsIgnoreCase("'ve") || word.equalsIgnoreCase("having") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("had") || word.equalsIgnoreCase("'d")) {
                                                                cat = cat + "-HV";
                                                                break block372;
                                                            } else if (EnglishTrain.splitAux >= 3 && (word.equalsIgnoreCase("do") || word.equalsIgnoreCase("did") || word.equalsIgnoreCase("does") || word.equalsIgnoreCase("help") || word.equalsIgnoreCase("helps") || word.equalsIgnoreCase("helped") || word.equalsIgnoreCase("helping"))) {
                                                                cat = cat + "-DO";
                                                            }
                                                            break block372;
                                                        }
                                                        if (EnglishTrain.splitAux > 0 && (baseCat.equals("VBZ") || baseCat.equals("VBP") || baseCat.equals("VBD") || baseCat.equals("VBN") || baseCat.equals("VBG") || baseCat.equals("VB"))) {
                                                            if (word.equalsIgnoreCase("is") || word.equalsIgnoreCase("am") || word.equalsIgnoreCase("are") || word.equalsIgnoreCase("was") || word.equalsIgnoreCase("were") || word.equalsIgnoreCase("'m") || word.equalsIgnoreCase("'re") || word.equalsIgnoreCase("'s") || word.equalsIgnoreCase("being") || word.equalsIgnoreCase("be") || word.equalsIgnoreCase("been")) {
                                                                cat = cat + "-BE";
                                                            }
                                                            if (word.equalsIgnoreCase("have") || word.equalsIgnoreCase("'ve") || word.equalsIgnoreCase("having") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("had") || word.equalsIgnoreCase("'d")) {
                                                                cat = cat + "-HV";
                                                            }
                                                        }
                                                        break block372;
                                                    }
                                                    for (int j = i2; j < sisters.length; ++j) {
                                                        if (!sisters[j].label().value().startsWith("VP")) continue;
                                                        Tree[] kids3 = sisters[j].children();
                                                        for (int k = 0; k < kids3.length; ++k) {
                                                            if (!kids3[k].label().value().startsWith("VBN") && !kids3[k].label().value().startsWith("VBD")) continue;
                                                            annotateHave = true;
                                                        }
                                                    }
                                                    cat = annotateHave ? cat + "-HV" : cat + "-BE";
                                                }
                                                if (EnglishTrain.markDitransV > 0 && cat.startsWith("VB")) {
                                                    cat = cat + EnglishTreebankParserParams.ditrans(parent);
                                                } else if (EnglishTrain.vpSubCat && cat.startsWith("VB")) {
                                                    cat = cat + EnglishTreebankParserParams.subCatify(parent);
                                                }
                                                tag = cat;
                                                break block373;
                                            }
                                            for (int i4 = 0; i4 < kids.length; ++i4) {
                                                if (!kids[i4].value().startsWith("NNP")) continue;
                                                split = true;
                                                break;
                                            }
                                            if (split) {
                                                cat = cat + "-NNP";
                                            }
                                        }
                                        if (EnglishTrain.splitVPNPAgr && baseCat.equals("NP") && baseParentStr.equals("S")) {
                                            if (baseTag.equals("NNPS") || baseTag.equals("NNS")) {
                                                cat = cat + "-PL";
                                            } else if (word.equalsIgnoreCase("many") || word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("plenty")) {
                                                cat = cat + "-PL";
                                            } else if (!(baseTag.equals("NN") || baseTag.equals("NNP") || baseTag.equals("POS") || baseTag.equals("CD") || baseTag.equals("PRP$") || baseTag.equals("JJ") || baseTag.equals("EX") || baseTag.equals("$") || baseTag.equals("RB") || baseTag.equals("FW") || baseTag.equals("VBG") || baseTag.equals("JJS") || baseTag.equals("JJR"))) {
                                                if (baseTag.equals("PRP")) {
                                                    if (word.equalsIgnoreCase("they") || word.equalsIgnoreCase("them") || word.equalsIgnoreCase("we") || word.equalsIgnoreCase("us")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else if (baseTag.equals("DT") || baseTag.equals("WDT")) {
                                                    if (word.equalsIgnoreCase("these") || word.equalsIgnoreCase("those") || word.equalsIgnoreCase("several")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else {
                                                    System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                }
                                            }
                                        }
                                        if (EnglishTrain.splitSTag && (baseCat.equals("S") || baseCat.equals("SINV") || baseCat.equals("SQ"))) {
                                            cat = EnglishTrain.splitVP >= 2 && (baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD")) ? cat + "-VBF" : (EnglishTrain.splitVP >= 3 ? cat + "-VBNF" : cat + "-" + baseTag);
                                        }
                                        if (EnglishTrain.markContainedVP && this.containsVP(t)) {
                                            cat = cat + "-vp";
                                        }
                                        if (EnglishTrain.markCC > 0) {
                                            for (int i5 = 1; i5 < kids.length - 1; ++i5) {
                                                String cat22 = kids[i5].label().value();
                                                if (cat22.startsWith("CC")) {
                                                    String word2 = kids[i5].children()[0].value();
                                                    if (word2.equals("either") || word2.equals("both") || word2.equals("neither")) continue;
                                                    cat = cat + "-CC";
                                                    break;
                                                }
                                                if (EnglishTrain.markCC <= 1 || !cat22.startsWith("CONJP")) continue;
                                                cat = cat + "-CC";
                                            }
                                        }
                                        if (EnglishTrain.splitSGapped != 1 || !baseCat.equals("S") || kids[0].label().value().startsWith("NP")) break block374;
                                        cat = cat + "-G";
                                        break block375;
                                    }
                                    if (EnglishTrain.splitSGapped != 2 || !baseCat.equals("S")) break block376;
                                    seenPredCat3 = false;
                                    seenNP2 = 0;
                                    break block377;
                                }
                                if (EnglishTrain.splitSGapped != 3 || !baseCat.equals("S")) break block378;
                                seenPredCat2 = false;
                                seenCC = false;
                                seenS2 = false;
                                seenNP = 0;
                                break block379;
                            }
                            if (EnglishTrain.splitSGapped != 4 || !baseCat.equals("S")) break block375;
                            seenPredCat = false;
                            sawSBeforePredCat = false;
                            seenS = 0;
                            seenNP = 0;
                            break block380;
                        }
                        for (int i6 = 0; i6 < kids.length; ++i6) {
                            String cat23 = kids[i6].label().value();
                            if (cat23.startsWith("NP")) {
                                ++seenNP2;
                                continue;
                            }
                            if (!cat23.startsWith("VP") && !cat23.startsWith("ADJP") && !cat23.startsWith("PP") && !cat23.startsWith("UCP")) continue;
                            seenPredCat3 = true;
                        }
                        if (seenNP2 == 0 || seenNP2 == 1 && !seenPredCat3) {
                            cat = cat + "-G";
                        }
                        break block375;
                    }
                    for (i = 0; i < kids.length; ++i) {
                        cat2 = kids[i].label().value();
                        if (cat2.startsWith("NP")) {
                            ++seenNP;
                            continue;
                        }
                        if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                            seenPredCat2 = true;
                            continue;
                        }
                        if (cat2.startsWith("CC")) {
                            seenCC = true;
                            continue;
                        }
                        if (!cat2.startsWith("S")) continue;
                        seenS2 = true;
                    }
                    if (!(seenCC && seenS2 || seenNP != 0 && (seenNP != 1 || seenPredCat2))) {
                        cat = cat + "-G";
                    }
                    break block375;
                }
                for (i = 0; i < kids.length; ++i) {
                    cat2 = kids[i].label().value();
                    if (cat2.startsWith("NP")) {
                        ++seenNP;
                        continue;
                    }
                    if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                        seenPredCat = true;
                        continue;
                    }
                    if (!cat2.startsWith("S")) continue;
                    ++seenS;
                    if (seenPredCat) continue;
                    sawSBeforePredCat = true;
                }
                if (!(seenS >= 2 || sawSBeforePredCat && seenPredCat || seenNP != 0 && (seenNP != 1 || seenPredCat))) {
                    cat = cat + "-G";
                }
            }
            if (EnglishTrain.splitNumNP && baseCat.equals("NP")) {
                boolean seenNum = false;
                for (int i = 0; i < kids.length; ++i) {
                    String cat2 = kids[i].label().value();
                    if (!cat2.startsWith("QP") && !cat2.startsWith("CD") && !cat2.startsWith("$") && !cat2.startsWith("#") && (!cat2.startsWith("NN") || cat2.indexOf("-%") < 0)) continue;
                    seenNum = true;
                    break;
                }
                if (seenNum) {
                    cat = cat + "-NUM";
                }
            }
            if (EnglishTrain.splitPoss > 0 && baseCat.equals("NP") && kids[kids.length - 1].label().value().startsWith("POS")) {
                if (EnglishTrain.splitPoss == 2) {
                    CategoryWordTag labelBot = t.isPrePreTerminal() ? new CategoryWordTag("NP^POSSP-B", word, tag) : new CategoryWordTag("NP^POSSP", word, tag);
                    t.setLabel(labelBot);
                    List<Tree> oldKids = t.getChildrenAsList();
                    ArrayList<Tree> newKids = new ArrayList<Tree>();
                    for (int i = 0; i < oldKids.size() - 1; ++i) {
                        newKids.add(oldKids.get(i));
                    }
                    t.setChildren(newKids);
                    cat = this.changeBaseCat(cat, "POSSP");
                    CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                    ArrayList<Tree> newerChildren = new ArrayList<Tree>(2);
                    newerChildren.add(t);
                    Tree last = oldKids.get(oldKids.size() - 1);
                    if (!last.value().equals("POS^NP")) {
                        System.err.println("Unexpected POS value (!): " + last);
                    }
                    last.setValue("POS^POSSP");
                    newerChildren.add(last);
                    return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                }
                cat = cat + "-P";
            }
            if (EnglishTrain.splitBaseNP > 0 && baseCat.equals("NP") && t.isPrePreTerminal()) {
                if (EnglishTrain.splitBaseNP == 2) {
                    if (!parentStr.startsWith("NP")) {
                        CategoryWordTag labelBot = new CategoryWordTag("NP^NP-B", word, tag);
                        t.setLabel(labelBot);
                        CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                        ArrayList<Tree> newerChildren = new ArrayList<Tree>(1);
                        newerChildren.add(t);
                        return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                    }
                    cat = cat + "-B";
                } else {
                    cat = cat + "-B";
                }
            }
            if (EnglishTrain.rightPhrasal && EnglishTreebankParserParams.rightPhrasal(t)) {
                cat = cat + "-RX";
            }
        }
        t.setLabel(new CategoryWordTag(cat, word, tag));
        return t;
    }

    private boolean containsVP(Tree t) {
        String cat = this.tlp.basicCategory(t.label().value());
        if (cat.equals("VP")) {
            return true;
        }
        Tree[] kids = t.children();
        for (int i = 0; i < kids.length; ++i) {
            if (!this.containsVP(kids[i])) continue;
            return true;
        }
        return false;
    }

    private static String deduceTag(String w) {
        String word = w.toLowerCase();
        if (word.endsWith("ing")) {
            return "VBG";
        }
        if (word.endsWith("d") || word.endsWith("t")) {
            return "VBN";
        }
        if (word.endsWith("s")) {
            return "VBZ";
        }
        if (word.equals("to")) {
            return "TO";
        }
        return "VB";
    }

    private static boolean rightPhrasal(Tree t) {
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith("NP") && !str.startsWith("PP") && !str.startsWith("VP") && !str.startsWith("S") && !str.startsWith("Q") && !str.startsWith("A")) continue;
            return true;
        }
        return false;
    }

    private static String subCatify(Tree t) {
        StringBuilder sb = new StringBuilder("^a");
        boolean n = false;
        boolean s = false;
        boolean p = false;
        for (int i = 0; i < t.children().length; ++i) {
            String childStr = t.children()[i].label().value();
            n = n || childStr.startsWith("NP");
            s = s || childStr.startsWith("S");
            p = p || childStr.startsWith("PP");
        }
        n = false;
        if (n) {
            sb.append("N");
        }
        if (p) {
            sb.append("P");
        }
        if (s) {
            sb.append("S");
        }
        return sb.toString();
    }

    private static String ditrans(Tree t) {
        int n = 0;
        Tree[] kids = t.children();
        int len = kids.length;
        for (int i = 0; i < len; ++i) {
            String childStr = kids[i].label().value();
            if (childStr.startsWith("NP") && childStr.indexOf("-TMP") < 0) {
                ++n;
                continue;
            }
            if (EnglishTrain.markDitransV != 1 || !childStr.startsWith("S")) continue;
            ++n;
        }
        if (n >= 2) {
            return "^2Arg";
        }
        return "";
    }

    private String changeBaseCat(String cat, String newBaseCat) {
        int i;
        int leng = cat.length();
        for (i = 1; i < leng && !this.tlp.isLabelAnnotationIntroducingCharacter(cat.charAt(i)); ++i) {
        }
        if (i < leng) {
            return newBaseCat + cat.substring(i);
        }
        return newBaseCat;
    }

    private static boolean hasClausalV(Tree tree) {
        if (tree.isPhrasal()) {
            if (tree.isPrePreTerminal() && tree.value().startsWith("N")) {
                return false;
            }
            Tree[] kids = tree.children();
            for (int i = 0; i < kids.length; ++i) {
                if (!EnglishTreebankParserParams.hasClausalV(kids[i])) continue;
                return true;
            }
            return false;
        }
        String str = tree.value();
        return str.startsWith("V") || str.startsWith("MD");
    }

    private static boolean hasV(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            String str = tags.get(i).toString();
            if (!str.startsWith("V") && !str.startsWith("MD")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasI(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            if (!tags.get(i).toString().startsWith("I")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasC(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            if (!tags.get(i).toString().startsWith("CC")) continue;
            return true;
        }
        return false;
    }

    public void display() {
        EnglishTrain.display();
    }

    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-splitIN")) {
            EnglishTrain.splitIN = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPercent")) {
            EnglishTrain.splitPercent = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitQuotes")) {
            EnglishTrain.splitQuotes = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitSFP")) {
            EnglishTrain.splitSFP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNNPposition")) {
            EnglishTrain.splitNNPposition = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-rbGPA")) {
            EnglishTrain.tagRBGPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitTRJJ")) {
            EnglishTrain.splitTRJJ = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitJJCOMP")) {
            EnglishTrain.splitJJCOMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitMoreLess")) {
            EnglishTrain.splitMoreLess = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryDT")) {
            EnglishTrain.unaryDT = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryRB")) {
            EnglishTrain.unaryRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryIN")) {
            EnglishTrain.unaryIN = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markReflexivePRP")) {
            EnglishTrain.markReflexivePRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitCC") && i + 1 < args.length) {
            EnglishTrain.splitCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitRB")) {
            EnglishTrain.splitRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitAux") && i + 1 < args.length) {
            EnglishTrain.splitAux = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSbar") && i + 1 < args.length) {
            EnglishTrain.splitSbar = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVP") && i + 1 < args.length) {
            EnglishTrain.splitVP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVPNPAgr")) {
            EnglishTrain.splitVPNPAgr = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gpaRootVP")) {
            EnglishTrain.gpaRootVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-makePPTOintoIN")) {
            EnglishTrain.makePPTOintoIN = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitSTag")) {
            EnglishTrain.splitSTag = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitSGapped") && i + 1 < args.length) {
            EnglishTrain.splitSGapped = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPpercent") && i + 1 < args.length) {
            EnglishTrain.splitNPpercent = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPPRP")) {
            EnglishTrain.splitNPPRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesV") && i + 1 < args.length) {
            EnglishTrain.dominatesV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dominatesI")) {
            EnglishTrain.dominatesI = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesC")) {
            EnglishTrain.dominatesC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNPNNP") && i + 1 < args.length) {
            EnglishTrain.splitNPNNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitTMP") && i + 1 < args.length) {
            EnglishTrain.splitTMP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPADV") && i + 1 < args.length) {
            EnglishTrain.splitNPADV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markContainedVP")) {
            EnglishTrain.markContainedVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markDitransV") && i + 1 < args.length) {
            EnglishTrain.markDitransV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPoss") && i + 1 < args.length) {
            EnglishTrain.splitPoss = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-baseNP") && i + 1 < args.length) {
            EnglishTrain.splitBaseNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-joinNounTags")) {
            EnglishTrain.joinNounTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-correctTags")) {
            EnglishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markCC") && i + 1 < args.length) {
            EnglishTrain.markCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noAnnotations")) {
            EnglishTrain.splitVP = 0;
            EnglishTrain.splitTMP = 0;
            EnglishTrain.splitSGapped = 0;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainNPTMPSubcategories")) {
            EnglishTest.retainNPTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainTMPSubcategories")) {
            EnglishTest.retainTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainADVSubcategories")) {
            EnglishTest.retainADVSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println("Warning: Default HeadFinder will be used.");
            }
        } else if (args[i].equalsIgnoreCase("-acl03pcfg")) {
            EnglishTrain.splitIN = 3;
            EnglishTrain.splitPercent = true;
            EnglishTrain.splitPoss = 1;
            EnglishTrain.splitCC = 2;
            EnglishTrain.unaryDT = true;
            EnglishTrain.unaryRB = true;
            EnglishTrain.splitAux = 1;
            EnglishTrain.splitVP = 2;
            EnglishTrain.splitSGapped = 4;
            EnglishTrain.dominatesV = 1;
            EnglishTrain.splitTMP = 1;
            EnglishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-linguisticPCFG")) {
            EnglishTrain.splitIN = 3;
            EnglishTrain.splitPercent = true;
            EnglishTrain.splitPoss = 1;
            EnglishTrain.splitCC = 2;
            EnglishTrain.unaryDT = true;
            EnglishTrain.unaryRB = true;
            EnglishTrain.splitAux = 2;
            EnglishTrain.splitVP = 3;
            EnglishTrain.splitSGapped = 4;
            EnglishTrain.dominatesV = 0;
            EnglishTrain.splitTMP = 1;
            EnglishTrain.splitBaseNP = 1;
            EnglishTrain.splitMoreLess = true;
            EnglishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodPCFG")) {
            EnglishTrain.splitIN = 4;
            EnglishTrain.splitPercent = true;
            EnglishTrain.splitNPpercent = 0;
            EnglishTrain.splitPoss = 1;
            EnglishTrain.splitCC = 1;
            EnglishTrain.unaryDT = true;
            EnglishTrain.unaryRB = true;
            EnglishTrain.splitAux = 2;
            EnglishTrain.splitVP = 3;
            EnglishTrain.splitSGapped = 4;
            EnglishTrain.dominatesV = 1;
            EnglishTrain.splitTMP = 1;
            EnglishTrain.splitNPADV = 1;
            EnglishTrain.splitBaseNP = 1;
            EnglishTrain.correctTags = true;
            EnglishTrain.markDitransV = 2;
            ++i;
        } else if (args[i].equalsIgnoreCase("-ijcai03")) {
            EnglishTrain.splitIN = 3;
            EnglishTrain.splitPercent = true;
            EnglishTrain.splitPoss = 1;
            EnglishTrain.splitCC = 2;
            EnglishTrain.unaryDT = false;
            EnglishTrain.unaryRB = false;
            EnglishTrain.splitAux = 0;
            EnglishTrain.splitVP = 2;
            EnglishTrain.splitSGapped = 4;
            EnglishTrain.dominatesV = 0;
            EnglishTrain.splitTMP = 1;
            EnglishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodFactored")) {
            EnglishTrain.splitIN = 3;
            EnglishTrain.splitPercent = true;
            EnglishTrain.splitPoss = 1;
            EnglishTrain.splitCC = 2;
            EnglishTrain.unaryDT = false;
            EnglishTrain.unaryRB = false;
            EnglishTrain.splitAux = 0;
            EnglishTrain.splitVP = 3;
            EnglishTrain.splitSGapped = 4;
            EnglishTrain.dominatesV = 0;
            EnglishTrain.splitTMP = 1;
            EnglishTrain.splitBaseNP = 1;
            EnglishTrain.markCC = 1;
            EnglishTrain.correctTags = true;
            ++i;
        }
        return i;
    }

    public List defaultTestSentence() {
        return Arrays.asList("This", "is", "just", "a", "test", ".");
    }

    public static void main(String[] args) {
        EnglishTreebankParserParams tlpp = new EnglishTreebankParserParams();
        MemoryTreebank tb = tlpp.memoryTreebank();
        tb.loadPath(args[0]);
        for (Tree t : tb) {
            t.pennPrint();
        }
    }

    public static class EnglishTrain {
        public static int splitIN = 0;
        public static boolean splitQuotes = false;
        public static boolean splitSFP = false;
        public static boolean splitPercent = false;
        public static int splitNPpercent = 0;
        public static boolean tagRBGPA = false;
        public static boolean splitNNPposition = false;
        public static boolean joinPound = false;
        public static boolean joinJJ = false;
        public static boolean joinNounTags = false;
        public static boolean splitPPJJ = false;
        public static boolean splitTRJJ = false;
        public static boolean splitJJCOMP = false;
        public static boolean splitMoreLess = false;
        public static boolean unaryDT = false;
        public static boolean unaryRB = false;
        public static boolean unaryPRP = false;
        public static boolean markReflexivePRP = false;
        public static boolean unaryIN = false;
        public static int splitCC = 0;
        public static boolean splitNOT = false;
        public static boolean splitRB = false;
        public static int splitAux = 0;
        public static boolean vpSubCat = false;
        public static int markDitransV = 0;
        public static int splitVP = 0;
        public static boolean splitVPNPAgr = false;
        public static boolean splitSTag = false;
        public static boolean markContainedVP = false;
        public static boolean splitNPPRP = false;
        public static int dominatesV = 0;
        public static boolean dominatesI = false;
        public static boolean dominatesC = false;
        public static int markCC = 0;
        public static int splitSGapped = 3;
        public static boolean splitNumNP = false;
        public static int splitPoss = 0;
        public static int splitBaseNP = 0;
        public static int splitTMP = 0;
        public static int splitSbar = 0;
        public static int splitNPADV = 0;
        public static int splitNPNNP = 0;
        public static boolean correctTags = false;
        public static boolean rightPhrasal = false;
        public static int sisterSplitLevel = 1;
        public static boolean gpaRootVP = false;
        public static boolean makePPTOintoIN = false;

        private EnglishTrain() {
        }

        public static void display() {
            String englishParams = "Using EnglishTreebankParserParams splitIN=" + splitIN + " sPercent=" + splitPercent + " sNNPpos=" + splitNNPposition + " sQuotes=" + splitQuotes + " sSFP=" + splitSFP + " rbGPA=" + tagRBGPA + " j#=" + joinPound + " jJJ=" + joinJJ + " jNounTags=" + joinNounTags + " sPPJJ=" + splitPPJJ + " sTRJJ=" + splitTRJJ + " sJJCOMP=" + splitJJCOMP + " sMoreLess=" + splitMoreLess + " unaryDT=" + unaryDT + " unaryRB=" + unaryRB + " unaryPRP=" + unaryPRP + " reflPRP=" + markReflexivePRP + " unaryIN=" + unaryIN + " sCC=" + splitCC + " sNT=" + splitNOT + " sRB=" + splitRB + " sAux=" + splitAux + " vpSubCat=" + vpSubCat + " mDTV=" + markDitransV + " sVP=" + splitVP + " sVPNPAgr=" + splitVPNPAgr + " sSTag=" + splitSTag + " mVP=" + markContainedVP + " sNP%=" + splitNPpercent + " sNPPRP=" + splitNPPRP + " dominatesV=" + dominatesV + " dominatesI=" + dominatesI + " dominatesC=" + dominatesC + " mCC=" + markCC + " sSGapped=" + splitSGapped + " numNP=" + splitNumNP + " sPoss=" + splitPoss + " baseNP=" + splitBaseNP + " sNPNNP=" + splitNPNNP + " sTMP=" + splitTMP + " sNPADV=" + splitNPADV + " cTags=" + correctTags + " rightPhrasal=" + rightPhrasal + " gpaRootVP=" + gpaRootVP + " splitSbar=" + splitSbar + " mPPTOiIN=" + makePPTOintoIN;
            System.err.println(englishParams);
        }
    }

    public static class EnglishTest {
        static boolean retainNPTMPSubcategories = false;
        static boolean retainTMPSubcategories = false;
        static boolean retainADVSubcategories = false;

        private EnglishTest() {
        }
    }

    protected class EnglishSubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected EnglishSubcategoryStripper() {
        }

        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            String s = lab.value();
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(s);
                leaf.setScore(tree.score());
                return leaf;
            }
            if (tree.isPhrasal()) {
                Tree[] kids;
                s = EnglishTest.retainADVSubcategories && s.indexOf("-ADV") >= 0 ? EnglishTreebankParserParams.this.tlp.basicCategory(s) + "-ADV" : (EnglishTest.retainTMPSubcategories && s.indexOf("-TMP") >= 0 ? EnglishTreebankParserParams.this.tlp.basicCategory(s) + "-TMP" : (EnglishTest.retainNPTMPSubcategories && s.startsWith("NP-TMP") ? "NP-TMP" : EnglishTreebankParserParams.this.tlp.basicCategory(s)));
                if (EnglishTrain.splitBaseNP == 2 && s.equals("NP") && (kids = tree.children()).length == 1 && EnglishTreebankParserParams.this.tlp.basicCategory(kids[0].value()).equals("NP")) {
                    ArrayList<Tree> kidkids = new ArrayList<Tree>();
                    for (int cNum = 0; cNum < kids[0].children().length; ++cNum) {
                        Tree child = kids[0].children()[cNum];
                        Tree newChild = this.transformTree(child);
                        if (newChild == null) continue;
                        kidkids.add(newChild);
                    }
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory(s);
                    return this.tf.newTreeNode(myLabel, kidkids);
                }
                if (EnglishTrain.splitPoss == 2 && s.equals("POSSP")) {
                    kids = tree.children();
                    ArrayList<Tree> newkids = new ArrayList<Tree>();
                    for (int j = 0; j < kids.length - 1; ++j) {
                        for (int cNum = 0; cNum < kids[j].children().length; ++cNum) {
                            Tree child = kids[0].children()[cNum];
                            Tree newChild = this.transformTree(child);
                            if (newChild == null) continue;
                            newkids.add(newChild);
                        }
                    }
                    Tree finalChild = this.transformTree(kids[kids.length - 1]);
                    newkids.add(finalChild);
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory("NP");
                    return this.tf.newTreeNode(myLabel, newkids);
                }
            } else {
                s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
            }
            ArrayList<Tree> children = new ArrayList<Tree>();
            for (int cNum = 0; cNum < tree.children().length; ++cNum) {
                Tree child = tree.children()[cNum];
                Tree newChild = this.transformTree(child);
                if (newChild == null) continue;
                children.add(newChild);
            }
            if (children.size() == 0) {
                return null;
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            ((HasCategory)newLabel).setCategory(s);
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }
}

