/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.trees.Labeled;
import edu.stanford.nlp.util.Scored;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constituent
implements Labeled,
Scored,
Label {
    public abstract int start();

    public abstract void setStart(int var1);

    public abstract int end();

    public abstract void setEnd(int var1);

    @Override
    public Label label() {
        return null;
    }

    @Override
    public void setLabel(Label label) {
    }

    @Override
    public Collection labels() {
        return Collections.singletonList(this.label());
    }

    @Override
    public void setLabels(Collection labels) {
        throw new UnsupportedOperationException("Constituent can't be multilabeled");
    }

    @Override
    public double score() {
        return Double.NaN;
    }

    public void setScore(double score) {
    }

    @Override
    public String toString() {
        Label lab = this.label();
        StringBuffer sb = lab != null ? new StringBuffer(((Object)lab).toString()) : new StringBuffer();
        sb.append("(").append(this.start()).append(",").append(this.end()).append(")");
        return sb.toString();
    }

    public int size() {
        return this.end() - this.start();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constituent) {
            Constituent c = (Constituent)obj;
            if (this.start() == c.start() && this.end() == c.end()) {
                Label lab1 = this.label();
                Label lab2 = c.label();
                if (lab1 == null) {
                    return lab2 == null;
                }
                return lab1.equals(lab2);
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.start() << 16 | this.end();
        Label lab = this.label();
        return lab == null ? hash : hash ^ lab.hashCode();
    }

    public boolean crosses(Constituent c) {
        return this.start() < c.start() && c.start() < this.end() && this.end() < c.end() || c.start() < this.start() && this.start() < c.end() && c.end() < this.end();
    }

    public boolean crosses(Collection<Constituent> constColl) {
        for (Constituent c : constColl) {
            if (!this.crosses(c)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Constituent c) {
        return this.start() <= c.start() && this.end() >= c.end();
    }

    @Override
    public String value() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.value();
    }

    @Override
    public void setValue(String value) {
        Label lab = this.label();
        if (lab != null) {
            lab.setValue(value);
        }
    }

    @Override
    public void setFromString(String labelStr) {
        Label lab = this.label();
        if (lab != null) {
            lab.setFromString(labelStr);
        }
    }

    public String toSentenceString(Sentence s) {
        StringBuffer sb = new StringBuffer();
        int end = this.end();
        for (int wordNum = this.start(); wordNum <= end; ++wordNum) {
            sb.append(s.getHasWord(wordNum));
            if (wordNum == end) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

