/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import java.io.Reader;

public class LabeledScoredTreeReaderFactory
implements TreeReaderFactory {
    private final LabelFactory lf;

    public LabeledScoredTreeReaderFactory() {
        this.lf = new CategoryWordTagFactory();
    }

    public LabeledScoredTreeReaderFactory(LabelFactory lf) {
        this.lf = lf;
    }

    public TreeReader newTreeReader(Reader in) {
        return new PennTreeReader(in, new LabeledScoredTreeFactory(this.lf), new BobChrisTreeNormalizer());
    }
}

