/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index<E>
extends AbstractCollection<E>
implements Serializable,
RandomAccess {
    protected List<E> objects = new ArrayList();
    protected Map<Object, Integer> indexes = new HashMap<Object, Integer>();
    protected boolean locked = false;
    private static final long serialVersionUID = 5398562825928375260L;

    @Override
    public void clear() {
        this.objects.clear();
        this.indexes.clear();
    }

    public int[] indices(List<E> elems) {
        int[] indices = new int[elems.size()];
        for (int i = 0; i < elems.size(); ++i) {
            indices[i] = this.indexOf(elems.get(i));
        }
        return indices;
    }

    public Collection<E> objects(final int[] indices) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return Index.this.objects.get(indices[index]);
            }

            @Override
            public int size() {
                return indices.length;
            }
        };
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public E get(int i) {
        return this.objects.get(i);
    }

    public List<E> objectsList() {
        return this.objects;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public int indexOf(Object o) {
        return this.indexOf(o, false);
    }

    public int indexOf(Object o, boolean add) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            if (add) {
                this.add(o);
                index = this.indexes.get(o);
            } else {
                return -1;
            }
        }
        return index;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed &= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean add(E o) {
        Integer index = this.indexes.get(o);
        if (index == null && !this.locked) {
            index = new Integer(this.objects.size());
            this.objects.add(o);
            this.indexes.put(o, index);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexes.containsKey(o);
    }

    public Index() {
    }

    public Index(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public void serializeReadable(String file) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.size(); ++i) {
                bw.write(i + "=" + this.get(i) + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Index deserializeReadable(String file) {
        Index<String> index = new Index<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                int start = line.indexOf(61);
                if (start == -1 || start == line.length() - 1) continue;
                index.add(line.substring(start + 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return index;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("[");
        for (int i = 0; i < this.objects.size(); ++i) {
            E e = this.objects.get(i);
            buff.append(i + "=" + e);
            if (i >= this.objects.size() - 1) continue;
            buff.append(",");
        }
        buff.append("]");
        return buff.toString();
    }

    public String firstNToString(int n) {
        int i;
        StringBuffer buff = new StringBuffer("[");
        for (i = 0; i < this.objects.size() && i < n; ++i) {
            E e = this.objects.get(i);
            buff.append(i + "=" + e);
            if (i >= this.objects.size() - 1) continue;
            buff.append(",");
        }
        if (i < this.objects.size()) {
            buff.append("...");
        }
        buff.append("]");
        return buff.toString();
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("A");
        list.add("C");
        Index index = new Index(list);
        System.out.println("Index size: " + index.size());
        System.out.println("Index has A? : " + index.contains("A"));
        System.out.println("Index of A: " + index.indexOf("A"));
        System.out.println("Index of B: " + index.indexOf("B"));
        System.out.println("Index of C: " + index.indexOf("C"));
        System.out.println("Object 0: " + index.get(0));
        index = index.unmodifiableView();
        System.out.println("Index size: " + index.size());
        System.out.println("Index has A? : " + index.contains("A"));
        System.out.println("Index of A: " + index.indexOf("A"));
        System.out.println("Index of B: " + index.indexOf("B"));
        System.out.println("Index of C: " + index.indexOf("C"));
        System.out.println("Object 0: " + index.get(0));
    }

    @Override
    public Iterator<E> iterator() {
        return this.objects.iterator();
    }

    @Override
    public boolean remove(Object o) {
        Integer oldIndex = this.indexes.remove(o);
        if (oldIndex == null) {
            return false;
        }
        this.objects.set(oldIndex, null);
        return true;
    }

    public Index<E> unmodifiableView() {
        Index newIndex = new Index<E>(){

            @Override
            public void unlock() {
                throw new UnsupportedOperationException("This is an unmodifiable view!");
            }
        };
        newIndex.objects = this.objects;
        newIndex.indexes = this.indexes;
        newIndex.lock();
        return newIndex;
    }
}

