/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.Lits2;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedDataStructureWithBinary
extends AbstractDataStructureFactory<ILits2> {
    private static final long serialVersionUID = 1L;

    @Override
    public ILits2 createLits() {
        return new Lits2();
    }

    @Override
    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = WLClause.sanityCheck(iVecInt, this.lits, this.solver);
        if (iVecInt2 == null) {
            return null;
        }
        if (iVecInt2.size() == 2) {
            ((ILits2)this.lits).binaryClauses(iVecInt2.get(0), iVecInt2.get(1));
            return null;
        }
        return WLClause.brandNewClause(this.solver, this.lits, iVecInt2);
    }

    @Override
    public void learnConstraint(Constr constr) {
        if (constr.size() == 2) {
            ((ILits2)this.lits).binaryClauses(constr.get(0), constr.get(1));
        } else {
            super.learnConstraint(constr);
        }
    }

    @Override
    public Constr createUnregisteredClause(IVecInt iVecInt) {
        return new LearntWLClause(iVecInt, (ILits)this.getVocabulary());
    }

    @Override
    public /* synthetic */ ILits createLits() {
        return this.createLits();
    }
}

