/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.BranchTagCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryBranchTagOperation
extends SVNOperation {
    private ISVNClientAdapter svnClient;
    private SVNUrl[] sourceUrls;
    private SVNUrl destinationUrl;
    private SVNRevision revision;
    private boolean makeParents;
    private String message;
    private boolean multipleTransactions = true;

    public RepositoryBranchTagOperation(IWorkbenchPart part, ISVNClientAdapter svnClient, SVNUrl[] sourceUrls, SVNUrl destinationUrl, SVNRevision revision, String message, boolean makeParents) {
        super(part);
        this.svnClient = svnClient;
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.revision = revision;
        this.message = message;
        this.makeParents = makeParents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            block6: {
                try {
                    BranchTagCommand command = new BranchTagCommand(this.svnClient, null, this.sourceUrls, this.destinationUrl, this.message, true, this.revision);
                    command.setMakeParents(this.makeParents);
                    command.setMultipleTransactions(this.multipleTransactions);
                    command.run(Policy.subMonitorFor(monitor, 1000));
                    SVNUIPlugin.getPlugin().getRepositoryManager().resourceCreated(null, null);
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block6;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void setMultipleTransactions(boolean multipleTransactions) {
        this.multipleTransactions = multipleTransactions;
    }

    protected String getTaskName() {
        return Policy.bind("BranchTagOperation.taskName");
    }
}

