/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.sentence;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.sentence.ISentenceDetector;
import edu.mit.parsing.core.rep.sentence.IndexedSentence;
import edu.mit.parsing.core.rep.sentence.Sentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceDefaultFactory
extends AbstractDescFactory2<IndexedSentence> {
    private ISentenceDetector detector;

    protected boolean doInit(IStoryModel data) {
        String id = (String)this.getConfiguration().get((Object)"detector");
        if (id == null) {
            return false;
        }
        this.detector = (ISentenceDetector)ParsingPlugin.getDefault().getSentenceDetectorManager().create(id);
        if (this.detector == null) {
            return false;
        }
        this.detector.init();
        return true;
    }

    public void dispose(IStoryModel model) {
        if (this.detector != null) {
            this.detector.dispose();
        }
        this.detector = null;
    }

    public SentenceDefaultFactory() {
        super(SentenceRep.getInstance(), TokenRep.getInstance());
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change change = event.getChange(TokenRep.getInstance());
        IHasPositionSet changedRegions = change.getChanges((IFlag)Flag.DESCS);
        DistinctRegionSet result = new DistinctRegionSet();
        IDescSet tokens = event.provider.getData().getDescriptions(TokenRep.getInstance());
        IDescSet sents = event.provider.getData().getDescriptions(SentenceRep.getInstance());
        for (IHasPosition region : changedRegions) {
            int right;
            int left = PositionUtils.findNextLeftBound((int)region.getOffset(), (IHasPositionSet)sents);
            if (left < 0) {
                left = Math.min(0, tokens.getOffset());
            }
            if (left < 0) {
                left = 0;
            }
            if ((right = PositionUtils.findNextRightBound((int)region.getRightOffset(), (IHasPositionSet)sents)) < 0) {
                right = Math.max(tokens.getRightOffset(), region.getRightOffset());
            }
            if (right < 0) {
                right = event.provider.getLength();
            }
            result.add(left, right - left);
        }
        return result;
    }

    protected IHasPositionSet<IndexedSentence> calculateData(IHasPosition region, IStoryModel model) {
        IDescSet ds = model.getData().getDescriptions(TokenRep.getInstance()).closedSet(region);
        ArrayList<TokenDesc> tokens = new ArrayList<TokenDesc>(ds.size());
        for (IDesc d : ds) {
            tokens.add(new TokenDesc(d));
        }
        List lists = this.detector.detect(tokens);
        HasPositionSet result = new HasPositionSet();
        LinkedList<IDesc> ts = new LinkedList<IDesc>();
        for (List list : lists) {
            ts.clear();
            for (TokenDesc td : list) {
                ts.add(td.getDesc());
            }
            result.add((Object)new IndexedSentence(new Sentence(ts, model.getData())));
        }
        return result;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new SentenceFactoryConfigDescriptor();
    }

    public static class SentenceFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public SentenceFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("detector", ParsingMessages.FACTORY_PARAM_NAME_SentenceDetector, ParsingMessages.FACTORY_PARAM_DESC_SentenceDetector, (IValidator)new ManagerBackedListValidator(ParsingPlugin.getDefault().getSentenceDetectorManager()), true, "DefaultDetectorID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }

    protected class TokenDesc
    implements IBaseToken {
        private final IDesc desc;
        private final String token;

        public TokenDesc(IDesc desc) {
            this.desc = desc;
            this.token = ((IBaseToken)desc.getData()).getToken();
        }

        public String getToken() {
            return this.token;
        }

        public IDesc getDesc() {
            return this.desc;
        }

        public String getSurface() {
            throw new UnsupportedOperationException();
        }
    }
}

