/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.rules;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.problems.AmbiguousStemProblem;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleStemRule
extends AbstractBuildRule {
    public SingleStemRule() {
        super(StemRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet stems;
        HashMap<IDesc, IDescSet> results = new HashMap<IDesc, IDescSet>();
        IDescSet stemDescs = model.getData().getDescriptions(StemRep.getInstance());
        for (IDesc d : model.getData().getDescriptions(TokenRep.getInstance())) {
            stems = stemDescs.matchSet((IHasPosition)d);
            if (stems.size() <= 1) continue;
            results.put(d, stems);
        }
        for (IDesc d : model.getData().getDescriptions(CollocRep.getInstance())) {
            stems = stemDescs.matchSet((IHasPosition)d);
            if (stems.size() <= 1) continue;
            results.put(d, stems);
        }
        HashSet<IDescSet> ambiguousStems = new HashSet<IDescSet>();
        for (Map.Entry entry : results.entrySet()) {
            ambiguousStems.add((IDescSet)entry.getValue());
        }
        if (ambiguousStems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDescSet d : ambiguousStems) {
            result.add((Object)new AmbiguousStemProblem((Collection<? extends IDesc>)d, this.getID()));
        }
        return result;
    }
}

