/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.handlers;

import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.ReferentProperty;
import edu.mit.discourse.ui.dialogs.RefExpSelectionDialog;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddPropertyHandler
extends AbstractHandler {
    public static final String PARAM_PropertyType = "edu.mit.discourse.ui.commandParameter.addProperty.PropertyType";

    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            this.setBaseEnabled(!tokens.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PropertyType type = (PropertyType)event.getObjectParameterForExecution(PARAM_PropertyType);
        if (type == null) {
            type = PropertyType.UNKNOWN;
        }
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!editor.getStoryModel().supports(RefPropRep.getInstance())) {
            return null;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)editor.getSelectedRange(), (IStoryData)editor.getStoryModel().getData());
        if (tokens.isEmpty()) {
            return null;
        }
        String tokenText = TextRep.getPrettyText((IHasPosition)tokens, (IStoryData)editor.getStoryModel().getData());
        String message = "Please select a referring expression to which to assign the property '" + tokenText + "'";
        IDesc refexp = RefExpSelectionDialog.open(editor, null, message, (IHasPosition)tokens);
        if (refexp == null) {
            return null;
        }
        ReferentProperty prop = new ReferentProperty(type, refexp, Collections.singleton(new Segment((IHasPosition)tokens, TokenRep.getInstance(), editor.getStoryModel().getData())));
        IHasPosition p = prop.calculatePosition();
        long id = editor.getStoryModel().getNextID();
        Desc desc = new Desc(id, RefPropRep.getInstance(), p, (IData)prop, null);
        desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)desc, (IMetaData)Origin.USER_SPECIFIED));
        desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)desc, (IMetaData)new Timing(start, "user")));
        editor.getStoryModel().applyChange((Object)this, (IModelChange)new AddDescriptionsChange((IDesc)desc), false);
        return null;
    }
}

