/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.helpers;

import edu.mit.discourse.core.rep.coref.model.ICorefModel;
import edu.mit.discourse.ui.content.CoreferenceContentProvider;
import edu.mit.discourse.ui.controllers.CorefController;
import edu.mit.discourse.ui.controllers.ICorefController;
import edu.mit.discourse.ui.label.CoreferenceLabelProvider;
import edu.mit.discourse.ui.label.RefExpDisplayText;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class CoreferenceCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = CoreferenceCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Coreference Relation";
    public static String buttonLabelSaveArg = "Save Coreference Relation";
    public static String actionLabelCommit = "Commit Coreference Relation";
    public static String actionLabelSave = "Save Coreference Relation";
    public static String actionLabelClear = "Clear Coreference Relation";
    public static String actionLabelCancel = "Cancel Edit";
    public static String actionLabelCommitArg = "Commit Coreference Relation";
    public static String actionLabelSaveArg = "Save Changes in Reference";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new coreference relation", 1);
    public static IMessageProvider commitMessage = new Message("Press the 'Commit' button to add this coreference relation to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'Save' button to change this coreference relation in the story model", 1);
    public static IMessageProvider createMessage = new Message("Press the 'Add' button to add this referring expression to the coreference relation", 2);
    protected ICorefController controller;
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected Text nameWidget;
    protected DescCaptureWidget<IDescController<IDescModel>> refExpWidget;
    protected TreeViewer corefViewer;
    protected Button addRefExpButton;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction addRefExpAction;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.controller = new CorefController(this.getStoryEditor(), "edu.mit.story.ui.annotation.target1");
        this.messageManager = new MessageProviderManager(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CoreferenceCreatorPage.this.updateFromModel();
            }
        });
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel());
        this.messageManager.add((INotifyingMessageProvider)this.controller.getRefExpController().getDescModel(), true);
        this.messageManager.setAllClearedMesage(clearedMessage);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        SashForm sash = new SashForm(control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        ColorManager.inheritColors((Control)sash);
        Composite widgetParent = new Composite((Composite)sash, 0);
        widgetParent.setLayoutData((Object)new GridData(4, 128, true, false));
        ColorManager.inheritColors((Control)widgetParent);
        widgetParent.setLayout((Layout)new GridLayout(2, false));
        this.createControlName(widgetParent);
        this.createControlRefExp(widgetParent);
        this.createControlButtons(widgetParent);
        this.corefViewer = new TreeViewer((Composite)sash, 2048);
        this.corefViewer.setContentProvider((IContentProvider)new CoreferenceContentProvider(this.getStoryEditor()));
        this.corefViewer.setLabelProvider((IBaseLabelProvider)new CoreferenceLabelProvider(this.getStoryEditor()));
        this.corefViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.controller.getModel()}));
        sash.setWeights(new int[]{3, 1});
        CommandContributionItem deleteAction = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        MenuManager m = new MenuManager();
        m.add((IContributionItem)new Separator("group.edit"));
        m.appendToGroup("group.edit", (IContributionItem)deleteAction);
        this.corefViewer.getTree().setMenu(m.createContextMenu((Control)this.corefViewer.getTree()));
        this.updateFromModel();
    }

    protected void createControlName(Composite parent) {
        Label label = new Label(parent, 0);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setText("Name");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.nameWidget = new Text(parent, 2052);
        this.nameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CoreferenceCreatorPage.this.controller.setName(CoreferenceCreatorPage.this.nameWidget.getText());
            }
        });
        this.nameWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createControlRefExp(Composite parent) {
        Label label = new Label(parent, 0);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setText("Referring Expression");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refExpWidget = new DescCaptureWidget<IDescController<IDescModel>>(parent, 0, this.controller.getRefExpController(), (IDescDisplayText)RefExpDisplayText.getInstance()){

            protected void createFollowingControls(Composite parent) {
                parent.setLayout((Layout)CoreferenceCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                CoreferenceCreatorPage.this.addRefExpButton = new Button(parent, 0);
                ColorManager.inheritColors((Control)CoreferenceCreatorPage.this.addRefExpButton);
                CoreferenceCreatorPage.this.addRefExpButton.setText("Add");
                CoreferenceCreatorPage.this.addRefExpAction = new ButtonAction(CoreferenceCreatorPage.this.addRefExpButton){

                    public void run() {
                        (this).CoreferenceCreatorPage.this.controller.addReferringExpression();
                    }
                };
            }
        };
        this.refExpWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.refExpWidget.getCaptureAction().setText("Capture Referring Expression");
        this.refExpWidget.getCaptureAction().setToolTipText("Capture Referring Expression");
        this.refExpWidget.getClearAction().setText("Clear Referring Expression");
        this.refExpWidget.getClearAction().setToolTipText("Clear Referring Expression");
    }

    protected void createControlButtons(Composite parent) {
        Label label = new Label(parent, 0);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite buttons = new Composite(parent, 0);
        buttons.setBackground(parent.getBackground());
        buttons.setForeground(parent.getForeground());
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttons.setLayout((Layout)CoreferenceCreatorPage.zeroMargins((GridLayout)new GridLayout(4, false)));
        label = new Label(buttons, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                CoreferenceCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                CoreferenceCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.refExpWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.refExpWidget.getCaptureAction().getActionDefinitionId(), this.refExpWidget.getCaptureAction());
        this.addRefExpAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.1");
        actionBars.setGlobalActionHandler(this.addRefExpAction.getActionDefinitionId(), (IAction)this.addRefExpAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        this.refExpWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        actionBars.setGlobalActionHandler(this.refExpWidget.getClearAction().getActionDefinitionId(), this.refExpWidget.getClearAction());
    }

    protected void updateFromModel() {
        String clearActionLabel;
        IMessageProvider defaultMsg;
        ICorefModel model = this.controller.getModel();
        IDescModel refModel = this.controller.getRefExpController().getDescModel();
        boolean isMainLoaded = model.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isMainLoaded ? saveMessage : commitMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableAddRef = !refModel.isCleared();
        boolean enableCommit = !model.isCleared() && this.messageManager.getMessageType() != 3 && refModel.isCleared();
        boolean enableClear = !model.isCleared() || !refModel.isCleared();
        String name = model.getName();
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String string = clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        if (!this.nameWidget.getText().equals(name)) {
            Point p = this.nameWidget.getSelection();
            this.nameWidget.setText(name);
            int idx = Math.min(this.nameWidget.getText().length(), p.x);
            this.nameWidget.setSelection(idx);
        }
        if (enableAddRef != this.addRefExpButton.isEnabled()) {
            this.addRefExpButton.setEnabled(enableAddRef);
        }
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        this.corefViewer.getTree().setRedraw(false);
        this.corefViewer.refresh();
        this.corefViewer.expandAll();
        this.corefViewer.getTree().setRedraw(true);
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public ICorefController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.corefViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.corefViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

