/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.hovers;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.Iterator;

public class RefPropHover
extends StoryTextHover {
    public RefPropHover() {
        super(RefPropRep.getInstance());
    }

    public String getHoverInfo(IStoryModel editor, int hoverOffset, IHasPosition selection) {
        if (!editor.supports(RefPropRep.getInstance())) {
            return null;
        }
        IDescSet propDescs = editor.getData().getDescriptions(RefPropRep.getInstance()).closedSet((IHasPosition)new SimplePosition(hoverOffset, 0));
        if (propDescs.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Referent Properties:\n");
        Iterator i = propDescs.iterator();
        while (i.hasNext()) {
            IReferentProperty prop = (IReferentProperty)((IDesc)i.next()).getData();
            sb.append(prop.getDisplayText());
            sb.append(" (");
            sb.append(prop.getType().getName());
            sb.append(") - ");
            IRefExp refexp = (IRefExp)prop.getReferringExpression().getData();
            sb.append(refexp.getDisplayText());
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

