/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.core.rep.relation.IAdjunct;
import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.core.rep.relation.ILexicalMarker;
import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.relation.AdjunctProxy;
import edu.mit.story.core.util.IHasDisplayText;
import edu.mit.story.ui.label.DecoratedImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RelationLabelProvider
extends LabelProvider {
    Image relImg;
    Image lmImg;
    Image lmRefImg;
    Image argImg;
    Image argRefImg;
    Image adjImg;
    Image adjRefImg;

    public String getText(Object element) {
        if (element instanceof IHasDisplayText) {
            return ((IHasDisplayText)element).getDisplayText();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IRelation) {
            return this.getRelationImage();
        }
        boolean makeRef = false;
        if (element instanceof AdjunctProxy) {
            AdjunctProxy ap = (AdjunctProxy)element;
            makeRef = ap.shouldMakeReferent();
        }
        if (element instanceof ILexicalMarker) {
            return makeRef ? this.getLexicalRefImage() : this.getLexicalImage();
        }
        if (element instanceof IArgument) {
            return makeRef ? this.getArgumentRefImage() : this.getArgumentImage();
        }
        if (element instanceof IAdjunct) {
            return makeRef ? this.getAdjunctRefImage() : this.getAdjunctImage();
        }
        return super.getImage(element);
    }

    protected Image getRelationImage() {
        if (this.relImg == null) {
            this.relImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/relation.gif");
        }
        return this.relImg;
    }

    protected Image getLexicalImage() {
        if (this.lmImg == null) {
            this.lmImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/lexmarker.gif");
        }
        return this.lmImg;
    }

    protected Image getArgumentImage() {
        if (this.argImg == null) {
            this.argImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/argument.gif");
        }
        return this.argImg;
    }

    protected Image getAdjunctImage() {
        if (this.adjImg == null) {
            this.adjImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/adjunct.gif");
        }
        return this.adjImg;
    }

    protected Image getLexicalRefImage() {
        if (this.lmRefImg == null) {
            ImageRegistry reg = DiscourseUIPlugin.getDefault().getImageRegistry();
            String key = "obj16/referent.gif_ovr16/referent_ovr.gif";
            this.lmRefImg = reg.get(key);
            if (this.lmRefImg == null) {
                Image baseImg = reg.get("obj16/lexmarker.gif");
                Image overlayImg = reg.get("ovr16/referent_ovr.gif");
                DecoratedImageDescriptor desc = new DecoratedImageDescriptor(baseImg, overlayImg, 128);
                reg.put(key, (ImageDescriptor)desc);
                this.lmRefImg = reg.get(key);
            }
        }
        return this.lmRefImg;
    }

    protected Image getArgumentRefImage() {
        if (this.argRefImg == null) {
            ImageRegistry reg = DiscourseUIPlugin.getDefault().getImageRegistry();
            String key = "obj16/argument.gif_ovr16/referent_ovr.gif";
            this.argRefImg = reg.get(key);
            if (this.argRefImg == null) {
                Image baseImg = reg.get("obj16/argument.gif");
                Image overlayImg = reg.get("ovr16/referent_ovr.gif");
                DecoratedImageDescriptor desc = new DecoratedImageDescriptor(baseImg, overlayImg, 128);
                reg.put(key, (ImageDescriptor)desc);
                this.argRefImg = reg.get(key);
            }
        }
        return this.argRefImg;
    }

    protected Image getAdjunctRefImage() {
        if (this.adjRefImg == null) {
            ImageRegistry reg = DiscourseUIPlugin.getDefault().getImageRegistry();
            String key = "obj16/adjunct.gif_ovr16/referent_ovr.gif";
            this.adjRefImg = reg.get(key);
            if (this.adjRefImg == null) {
                Image baseImg = reg.get("obj16/adjunct.gif");
                Image overlayImg = reg.get("ovr16/referent_ovr.gif");
                DecoratedImageDescriptor desc = new DecoratedImageDescriptor(baseImg, overlayImg, 128);
                reg.put(key, (ImageDescriptor)desc);
                this.adjRefImg = reg.get(key);
            }
        }
        return this.adjRefImg;
    }
}

