/* Filename: Duration.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 9, 2010
 */
package nil.ucm.indications2.ui.agreement;

import java.util.Date;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class Duration implements IDuration {
	
	private final long start;
	private final long length;
	private final long end;
	
	public Duration(Date start){
		this(start.getTime(), start.getTime());
	}
	
	public Duration(long start, long end){
		if(end < start) throw new IllegalArgumentException();
		this.start = start;
		this.length = end-start;
		this.end = end;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IDuration#getLength()
	 */
	public long getLength() {
		return length;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IDuration#getStart()
	 */
	public long getStart() {
		return start;
	}

	/* 
	 * (non-Javadoc) @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(IDuration o) {
		if(start < o.getStart()) return -1;
		if(start > o.getStart()) return 1;
		if(end < o.getEnd()) return -1;
		if(end > o.getEnd()) return 1;
		return 0;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IDuration#getEnd()
	 */
	public long getEnd() {
		return end;
	}
	
	public String toString(){
		StringBuilder sb = new StringBuilder();
		sb.append("[start=" + start);
		sb.append(", end=" + end + ']');
		return sb.toString();
	}

}
