/* Filename: IndArgController.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 06/10/2009
 */
package nil.ucm.indications2.ui.controllers;

import nil.ucm.indications2.core.rep.IndicationType;
import nil.ucm.indications2.core.rep.model.IIndArgModel;
import nil.ucm.indications2.core.rep.model.IndArgModel;

import org.eclipse.jface.viewers.ISelection;

import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AnnotationModelChild;

/** 
 *   Controller for the arguments of a reference when creating an indication structure.
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class IndArgController extends SegmentSetController implements IIndArgController {

	public IndArgController(IIndArgModel argModel, String annoID, IStoryEditor editor) {
		super(argModel, annoID, AnnotationModelChild.createChildAnnotationModel(editor), editor);
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications.ui.controllers.IIndArgController#getArgModel()
	 */
	public IIndArgModel getArgModel() {
		return (IIndArgModel)model;
	}
	
	public void setIndicationType(ISelection sel) {
		IndicationType type = SelectionUtils.extractSingle(sel, IndicationType.class);
		this.setIndicationType(type);
	}
	
	public void setIndicationType(IndicationType type) {
//		((IndArgModel)getModel()).setIndicationType(type);
		
		if (!((IndArgModel)getModel()).getSegments().isEmpty())
			((IndArgModel)getModel()).setType(type);
	}

}
