/* Filename: CorefModel.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Oct 4, 2010
 */
package edu.mit.discourse.core.rep.coref.model;

import org.eclipse.jface.dialogs.IMessageProvider;

import edu.mit.discourse.core.rep.coref.Coref;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.NotifyingDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.validation.Message;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class CorefModel extends AbstractViewModel implements ICorefModel {
	
	private final IStoryModel model;

	private String name = (getDefaultName() == null) ? "" : getDefaultName();
	private IDesc loaded = getDefaultLoaded();
	private IDescSet refexps = new NotifyingDescSet(RefExpRep.getInstance(), new INotifyCollectionCallback<IDesc>(){
		public void elementAdded(IDesc added) {
			if(refexps.size() == 1 && name.length() == 0){
				IRefExp refexp = (IRefExp)added.getData();
				setName(refexp.getDisplayText());
			}
			fireChanged();
		}
		public void elementRemoved(IDesc removed) {
			fireChanged();
		}
	});
	public CorefModel(IStoryModel model){
		if(model == null)
			throw new NullPointerException();
		this.model = model;
	}
	
	public IStoryModel getStoryModel(){
		return model;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.descriptor.IHasName#getName()
	 */
	public String getName() {
		return name;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	public IHasPosition calculatePosition() {
		return refexps.isEmpty() ? null : new SimplePosition(refexps);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	public IHasPosition getDisplayPosition() {
		return refexps.isEmpty() ? null : new SimplePosition(refexps.first());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	public int getLength() {
		return refexps.isEmpty() ? null : refexps.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	public int getOffset() {
		return refexps.isEmpty() ? null : refexps.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	public int getRightOffset() {
		return refexps.isEmpty() ? null : refexps.getRightOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.model.ICorefModel#setName(java.lang.String)
	 */
	public void setName(String newName) {
		if(newName == null){
			newName = getDefaultName();
			if(newName == null)
				newName = "";
		}
		if(name.equals(newName))
			return;
		name = newName;
		fireChanged();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.model.ICorefModel#getLoaded()
	 */
	public IDesc getLoaded() {
		return loaded;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.model.ICorefModel#load(edu.mit.story.core.desc.IDesc)
	 */
	public void load(IDesc desc) {
		ICoref coref = (ICoref)desc.getData();
		internalClear();
		
		loaded = desc;
		name = coref.getName();
		refexps.addAll(coref.getReferentialExpressions());
		fireChanged();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.NotifyingMessageProvider#calculateMessage()
	 */
	@Override
	protected IMessageProvider calculateMessage() {
		if(refexps.isEmpty())
			return new Message("Add a referring expression to the coreference relation", IMessageProvider.ERROR);
		if(name.trim().length() == 0)
			return new Message("Enter a name for the coreference relation", IMessageProvider.ERROR);
		return Message.NO_MESSAGE;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.datamodel.AbstractViewModel#internalClear()
	 */
	@Override
	protected void internalClear() {
		this.loaded = null;
		this.name = getDefaultName();
		this.refexps.clear();
	}

	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public String getDefaultName() {
		return "";
	}

	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	protected IDesc getDefaultLoaded() {
		return null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IClearable#isCleared()
	 */
	public boolean isCleared() {
		if(!name.equals(getDefaultName()))
			return false;
		if(loaded != getDefaultLoaded())
			return false;
		if(!refexps.isEmpty())
			return false;
		return true;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.model.ICorefModel#create()
	 */
	public ICoref create() {
		return new Coref(name, refexps);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.ICoref#getReferentialExpressions()
	 */
	public IDescSet getReferentialExpressions() {
		return refexps;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.desc.IDesc, edu.mit.story.core.model.IStoryModel)
	 */
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		throw new UnsupportedOperationException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

}
