/* Filename: AddEntityChange.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 23, 2007
 */
package edu.mit.discourse.core.rep.referent.change;

import java.util.Collections;

import edu.mit.discourse.core.DiscourseMessages;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.IOrigin;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;


/** One line description goes here...
 * More detail goes here...
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 23, 2007)
 * @since 1.5.0
 */
public class CreateReferentChange extends AbstractModelChange {
	
	protected final String name;
	protected final IHasPosition p;
	protected final ITiming timing;
	
	public CreateReferentChange(IHasPosition p, ITiming timing) {
		this(null, p, timing);
	}
	
	public CreateReferentChange(String name, IHasPosition p, ITiming timing) {
		super(DiscourseMessages.CHANGE_CreateEntity_name);
		
		this.name = name;
		this.p = new SimplePosition(p);
		this.timing = timing;
	}

	/* (non-Javadoc) @see edu.mit.story.core.provider.changes.AbstractSynchronizedProviderChange#synchronizedDoApply(java.lang.Object, edu.mit.story.core.provider.IDescriptionProvider) */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		
		// make the segment
		ISegment segment = new Segment(p, TokenRep.getInstance(), model.getData());
		
		// get the name
		String newName = (name == null) ? segment.getDisplayText() : name;
		
		// add the new description
		IReferent newData = new Referent(newName, null, Collections.singleton(Collections.singleton(segment)));
		IDesc newDesc = new Desc(model.getNextID(), ReferentRep.getInstance(), newData.calculatePosition(), newData, null);
		newDesc.getMetaData().addDesc(new MetaDesc<IOrigin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
		if(timing != null)
			newDesc.getMetaData().addDesc(new MetaDesc<ITiming>(TimingMetaRep.getInstance(), newDesc, timing));
		
		AddDescriptionsChange change = new AddDescriptionsChange(newDesc);
		return change.apply(source, model);
	}

}
