/* Filename: RefPropsRep.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 23, 2009
 */
package edu.mit.discourse.core.rep.refprops;

import java.util.ArrayList;
import java.util.List;

import org.osgi.framework.Version;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public final class RefPropRep extends AbstractRep {
	
	
	
	/** 
	 * The default identifier for this representation, which is {@value}
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public final static String ID = "edu.mit.discourse.rep.refprop";
	
	// the singleton instance
	private static IRep instance = null;

	/**
	 * Returns the singleton instance of this class;
	 *
	 * @return the singleton instance of this class
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static IRep getInstance() {
		if(instance == null) 
			instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
		return instance;
	}

	/**
	 * TODO: Write comment
	 *
	 * @param format
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public RefPropRep() {
		super(IReferentProperty.class, v02, 1);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#initAntecedentsInternal(edu.mit.story.core.rep.IRepSet)
	 */
	
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(TokenRep.getInstance());
		container.add(RefExpRep.getInstance());
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
	 */
	public String serialize(IData data) {
		IReferentProperty prop = (IReferentProperty)data;
		List<String> fields = new ArrayList<String>(3);
		fields.add(Long.toString(prop.getReferringExpression().getID()));
		fields.add(prop.getType().name());
		fields.add(SegmentMapper.serializeStatic(prop.getExtent()));
		return BlockMapper.PIPE.serialize(fields);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public IData reconstitute(IHasPosition p, String description, IStoryModel model) {
		return reconstitute(p, description, model, getVersion());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public ReferentProperty reconstitute(IHasPosition p, String description, IStoryModel model, Version ver) {
		
		if(v1.equals(ver))
			ver = v01;
		
		if(v01.equals(ver))
			return reconstituteV01(p, description, model);
		
		if(v02.equals(ver))
			return reconstituteV02(p, description, model);
		
		return reconstitute(p, description, model, getVersion());

	}
	
//	/* 
//	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
//	 */
//	public String serializeV01(IData data) {
//		IReferentProperty prop = (IReferentProperty)data;
//		String body = SegmentMapper.serializeStatic(prop.getExtent());
//		return Long.toString(prop.getReferringExpression().getID()) + '|' + body;
//	}
	
	/**
	 * TODO: Write comment
	 *
	 * @param p
	 * @param description
	 * @param model
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	protected ReferentProperty reconstituteV01(IHasPosition p, String description, IStoryModel model){
		int index = description.indexOf('|');
		
		// get referent
		long id = Long.parseLong(description.substring(0, index));
		IDesc ref = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(id);
		
		// get segments
		IValueMapper<ISegment> mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
		List<ISegment> segments = mapper.reconstitute(description.substring(index+1));
		
		// make object
		return new ReferentProperty(PropertyType.UNKNOWN, ref, segments);
	}


	/**
	 * TODO: Write comment
	 *
	 * @param p
	 * @param description
	 * @param model
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	protected ReferentProperty reconstituteV02(IHasPosition p, String description, IStoryModel model){
		
		List<String> fields = BlockMapper.PIPE.reconstitute(description);
		
		// get referent
		long id = Long.parseLong(fields.get(0));
		IDesc ref = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(id);
		
		// get type
		PropertyType type = PropertyType.valueOf(fields.get(1));
		
		// get segments
		IValueMapper<ISegment> mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
		List<ISegment> segments = mapper.reconstitute(fields.get(2));
		
		return new ReferentProperty(type, ref, segments);
	}

	/**
	 * Returns <code>true</code> if the specified referent has a property in the
	 * model; <code>false</code> otherwise
	 * 
	 * @param ref
	 *            the referent for which properties should be located
	 * @param model
	 *            the model which should be searched for properties refering to
	 *            the referent
	 * @return <code>true</code> if the specified referent has a property in the
	 *         model; <code>false</code> otherwise
	 * @throws NullPointerException
	 *             if either model or referent is <code>null</code>
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public static boolean hasProperties(IRefExp ref, IStoryModel model){
		if(ref == null) 
			throw new NullPointerException();
		
		// if the story editor does not support referent properties,
		// there are no properties
		if(!model.supports(getInstance())) 
			return false;
		
		// look for a property that has the specified referent 
		// as its target
		IDescSet descs = model.getData().getDescriptions(getInstance());
		descs = descs.openSet(ref.calculatePosition());
		IReferentProperty prop;
		for(IDesc d : descs){
			prop = (IReferentProperty)d.getData();
			if(prop.getReferringExpression().getData() == ref) 
				return true;
		}
		return false;
	}

	/**
	 * Returns a list, in text order, of the property descriptions.
	 *
	 * @param referent
	 * @return
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public static IDescSet collectProperties(IRefExp ref, IStoryModel model){
		if(ref == null) 
			throw new NullPointerException();
		
		IDescSet props = new DescSet(getInstance());
	
		// if the story editor does not support referent properties,
		// there are no properties
		if(!model.supports(getInstance())) 
			return props;
		
		// look for properties that has the specified referent  as its target
		IDescSet descs = model.getData().getDescriptions(getInstance());
		descs = descs.openSet(ref.calculatePosition());
		IReferentProperty prop;
		for(IDesc d : descs){
			prop = (IReferentProperty)d.getData();
			if(prop.getReferringExpression().getData() == ref) 
				props.add(d);
		}
		
		return props;
	}

}
