/* Filename: IndicationType.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 06/10/2009
 */
package nil.ucm.indications2.core.rep;

import edu.mit.story.core.descriptor.IHasDescription;

/** 
 *   Types for the indications based on the function they have in the text.
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 6, 2009)
 * @since nil.ucm.indications.core 1.0.0
 */
public enum IndicationType implements IHasDescription {
	
	DISTINCTIVE("Distinctive"),
	DESCRIPTIVE("Descriptive"),
	OTHER("Other"),
	UNKNOWN("Unknown");
	
//	INFORMATIVE("Informative"),
//	OTHER("Other"),
//	UNKNOWN("Unknown");
	
	// instance field
	private final String name;
	
	// private enum constructor
	private IndicationType(String name){
		if(name.trim().length() == 0) throw new IllegalArgumentException();
		this.name = name;
	}
	
	/**
	 * Returns the description of this label. Will not return <code>null</code>,
	 * the empty string, or all whitespace.
	 * 
	 * @return the description of this label
	 */
	public String getDescription(){
		return name;
	}
}
